/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiTappedPublisher;
import io.helidon.common.reactive.Single;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;

interface DelayedTask<T> {
    public CompletionStage<Void> execute();

    public T result();

    public T error(Throwable var1);

    default public boolean hadData() {
        return false;
    }

    public static <T> DelayedTask<Multi<T>> createMulti(final Supplier<? extends Flow.Publisher<T>> supplier) {
        return new DelayedTask<Multi<T>>(){
            private final AtomicBoolean completed = new AtomicBoolean();
            private final AtomicBoolean hasData = new AtomicBoolean();
            private final LazyValue<CompletableFuture<Void>> completionMarker = LazyValue.create(CompletableFuture::new);
            private final LazyValue<CompletableFuture<Flow.Publisher<T>>> publisherFuture = LazyValue.create(CompletableFuture::new);
            private final LazyValue<Multi<T>> multi = LazyValue.create(() -> MultiTappedPublisher.builder((Multi)Multi.create((CompletionStage)((CompletionStage)this.publisherFuture.get())).flatMap(Function.identity(), 32L, true, 32L)).onCancelCallback(() -> this.failMarker(new CancellationException("Multi was cancelled"))).onCompleteCallback(this::completeMarker).onErrorCallback(this::failMarker).onNextCallback(it -> this.hasData.set(true)).build());

            @Override
            public CompletionStage<Void> execute() {
                ((CompletableFuture)this.publisherFuture.get()).complete((Flow.Publisher)supplier.get());
                return (CompletionStage)this.completionMarker.get();
            }

            @Override
            public Multi<T> result() {
                return (Multi)this.multi.get();
            }

            @Override
            public Multi<T> error(Throwable throwable) {
                return Multi.error((Throwable)throwable);
            }

            public String toString() {
                return "multi:" + System.identityHashCode(this);
            }

            @Override
            public boolean hadData() {
                return this.hasData.get();
            }

            private void failMarker(Throwable throwable) {
                if (this.completed.compareAndSet(false, true)) {
                    ((CompletableFuture)this.completionMarker.get()).completeExceptionally(throwable);
                }
            }

            private void completeMarker() {
                if (this.completed.compareAndSet(false, true)) {
                    ((CompletableFuture)this.completionMarker.get()).complete(null);
                }
            }
        };
    }

    public static <T> DelayedTask<Single<T>> createSingle(final Supplier<? extends CompletionStage<T>> supplier) {
        return new DelayedTask<Single<T>>(){
            private final LazyValue<CompletableFuture<T>> resultFuture = LazyValue.create(CompletableFuture::new);

            @Override
            public CompletionStage<Void> execute() {
                CompletionStage<Object> result;
                try {
                    result = (CompletionStage<Object>)supplier.get();
                }
                catch (Exception e) {
                    result = CompletableFuture.failedStage(e);
                }
                CompletableFuture future = (CompletableFuture)this.resultFuture.get();
                result.handle((it, throwable) -> {
                    if (throwable == null) {
                        future.complete(it);
                    } else {
                        future.completeExceptionally((Throwable)throwable);
                    }
                    return null;
                });
                return result.thenRun(() -> {});
            }

            @Override
            public Single<T> result() {
                return Single.create((CompletionStage)((CompletionStage)this.resultFuture.get()));
            }

            @Override
            public Single<T> error(Throwable throwable) {
                return Single.error((Throwable)throwable);
            }

            public String toString() {
                return "single:" + System.identityHashCode(this);
            }
        };
    }
}

