/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import java.util.Set;

@FunctionalInterface
interface ErrorChecker {
    public boolean shouldSkip(Throwable var1);

    public static ErrorChecker create(Set<Class<? extends Throwable>> skipOnSet, Set<Class<? extends Throwable>> applyOnSet) {
        Set<Class<? extends Throwable>> skipOn = Set.copyOf(skipOnSet);
        Set<Class<? extends Throwable>> applyOn = Set.copyOf(applyOnSet);
        if (skipOn.isEmpty()) {
            if (applyOn.isEmpty()) {
                return throwable -> false;
            }
            return throwable -> !applyOn.contains(throwable.getClass());
        }
        if (applyOn.isEmpty()) {
            return throwable -> skipOn.contains(throwable.getClass());
        }
        throw new IllegalArgumentException("You have defined both skip and apply set of exception classes. This cannot be correctly handled; skipOn: " + skipOn + " applyOn: " + applyOn);
    }
}

