/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.faulttolerance.RetryImpl;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public interface Retry
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public static class JitterRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final Supplier<Integer> randomJitter;

        private JitterRetryPolicy(Builder builder) {
            int jitterMillis;
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            long jitter = builder.jitter.toMillis();
            int n = jitterMillis = jitter > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)jitter;
            if (jitterMillis == 0) {
                this.randomJitter = () -> 0;
            } else {
                Random random = new Random();
                this.randomJitter = () -> random.nextInt(jitterMillis * 2) - jitterMillis;
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallNanos, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            long delay = this.delayMillis;
            int jitterRandom = this.randomJitter.get();
            delay += (long)jitterRandom;
            delay = Math.max(0L, delay);
            return Optional.of(delay);
        }

        public static class Builder
        implements io.helidon.common.Builder<JitterRetryPolicy> {
            private int calls = 3;
            private Duration delay = Duration.ofMillis(200L);
            private Duration jitter = Duration.ofMillis(50L);

            private Builder() {
            }

            public JitterRetryPolicy build() {
                return new JitterRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder jitter(Duration jitter) {
                this.jitter = jitter;
                return this;
            }
        }
    }

    public static class DelayingRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final double delayFactor;

        private DelayingRetryPolicy(Builder builder) {
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            this.delayFactor = builder.delayFactor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DelayingRetryPolicy noDelay(int calls) {
            return DelayingRetryPolicy.builder().delay(Duration.ZERO).delayFactor(0.0).calls(calls).build();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallMillis, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            if (call == 0) {
                return Optional.of(this.delayMillis);
            }
            return Optional.of((long)((double)lastDelay * this.delayFactor));
        }

        public static class Builder
        implements io.helidon.common.Builder<DelayingRetryPolicy> {
            private int calls = 3;
            private double delayFactor = 2.0;
            private Duration delay = Duration.ofMillis(200L);

            public DelayingRetryPolicy build() {
                return new DelayingRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder delayFactor(double delayFactor) {
                this.delayFactor = delayFactor;
                return this;
            }
        }
    }

    public static interface RetryPolicy {
        public Optional<Long> nextDelayMillis(long var1, long var3, int var5);
    }

    public static class Builder
    implements io.helidon.common.Builder<Retry> {
        private final Set<Class<? extends Throwable>> applyOn = new HashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new HashSet<Class<? extends Throwable>>();
        private RetryPolicy retryPolicy = JitterRetryPolicy.builder().calls(4).delay(Duration.ofMillis(200L)).jitter(Duration.ofMillis(50L)).build();
        private Duration overallTimeout = Duration.ofSeconds(1L);
        private LazyValue<? extends ScheduledExecutorService> scheduledExecutor = FaultTolerance.scheduledExecutor();

        private Builder() {
        }

        public Retry build() {
            return new RetryImpl(this);
        }

        public Builder retryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        public Builder applyOn(Class<? extends Throwable> ... classes) {
            this.applyOn.clear();
            Arrays.stream(classes).forEach(this::addApplyOn);
            return this;
        }

        public Builder addApplyOn(Class<? extends Throwable> clazz) {
            this.applyOn.add(clazz);
            return this;
        }

        public Builder skipOn(Class<? extends Throwable> ... classes) {
            this.skipOn.clear();
            Arrays.stream(classes).forEach(this::addSkipOn);
            return this;
        }

        public Builder addSkipOn(Class<? extends Throwable> clazz) {
            this.skipOn.add(clazz);
            return this;
        }

        public Builder scheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = LazyValue.create((Object)scheduledExecutor);
            return this;
        }

        public Builder overallTimeout(Duration overallTimeout) {
            this.overallTimeout = overallTimeout;
            return this;
        }

        Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        RetryPolicy retryPolicy() {
            return this.retryPolicy;
        }

        Duration overallTimeout() {
            return this.overallTimeout;
        }

        LazyValue<? extends ScheduledExecutorService> scheduledExecutor() {
            return this.scheduledExecutor;
        }
    }
}

