/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.DelayedTask;
import io.helidon.faulttolerance.ErrorChecker;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.Retry;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class RetryImpl
implements Retry {
    private final LazyValue<? extends ScheduledExecutorService> scheduledExecutor;
    private final ErrorChecker errorChecker;
    private final long maxTimeNanos;
    private final Retry.RetryPolicy retryPolicy;

    RetryImpl(Retry.Builder builder) {
        this.scheduledExecutor = builder.scheduledExecutor();
        this.errorChecker = ErrorChecker.create(builder.skipOn(), builder.applyOn());
        this.maxTimeNanos = builder.overallTimeout().toNanos();
        this.retryPolicy = builder.retryPolicy();
    }

    @Override
    public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        return this.retryMulti(new RetryContext<Flow.Publisher<T>>(supplier));
    }

    @Override
    public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        return this.retrySingle(new RetryContext<CompletionStage<T>>(supplier));
    }

    private <T> Single<T> retrySingle(RetryContext<? extends CompletionStage<T>> context) {
        long nanos;
        long delay = 0L;
        int currentCallIndex = context.count.getAndIncrement();
        if (currentCallIndex != 0) {
            Optional<Long> maybeDelay = this.retryPolicy.nextDelayMillis(context.startedMillis, context.lastDelay.get(), currentCallIndex);
            if (maybeDelay.isEmpty()) {
                return Single.error((Throwable)context.throwable());
            }
            delay = maybeDelay.get();
        }
        if ((nanos = System.nanoTime() - context.startedNanos) > this.maxTimeNanos) {
            return Single.error((Throwable)new TimeoutException("Execution took too long. Already executing: " + TimeUnit.NANOSECONDS.toMillis(nanos) + " ms, must timeout after: " + TimeUnit.NANOSECONDS.toMillis(this.maxTimeNanos) + " ms."));
        }
        DelayedTask task = DelayedTask.createSingle(context.supplier);
        if (delay == 0L) {
            task.execute();
        } else {
            ((ScheduledExecutorService)this.scheduledExecutor.get()).schedule(task::execute, delay, TimeUnit.MILLISECONDS);
        }
        return task.result().onErrorResumeWithSingle(throwable -> {
            Throwable cause = FaultTolerance.cause(throwable);
            context.thrown.add(cause);
            if (this.errorChecker.shouldSkip(cause)) {
                return Single.error((Throwable)context.throwable());
            }
            return this.retrySingle(context);
        });
    }

    private <T> Multi<T> retryMulti(RetryContext<? extends Flow.Publisher<T>> context) {
        long nanos;
        long delay = 0L;
        int currentCallIndex = context.count.getAndIncrement();
        if (currentCallIndex != 0) {
            Optional<Long> maybeDelay = this.retryPolicy.nextDelayMillis(context.startedMillis, context.lastDelay.get(), currentCallIndex);
            if (maybeDelay.isEmpty()) {
                return Multi.error((Throwable)context.throwable());
            }
            delay = maybeDelay.get();
        }
        if ((nanos = System.nanoTime() - context.startedNanos) > this.maxTimeNanos) {
            return Multi.error((Throwable)new TimeoutException("Execution took too long. Already executing: " + TimeUnit.NANOSECONDS.toMillis(nanos) + " ms, must timeout after: " + TimeUnit.NANOSECONDS.toMillis(this.maxTimeNanos) + " ms."));
        }
        DelayedTask task = DelayedTask.createMulti(context.supplier);
        if (delay == 0L) {
            task.execute();
        } else {
            ((ScheduledExecutorService)this.scheduledExecutor.get()).schedule(task::execute, delay, TimeUnit.MILLISECONDS);
        }
        return task.result().onErrorResumeWith(throwable -> {
            Throwable cause = FaultTolerance.cause(throwable);
            context.thrown.add(cause);
            if (task.hadData() || this.errorChecker.shouldSkip(cause)) {
                return Multi.error((Throwable)context.throwable());
            }
            return this.retryMulti(context);
        });
    }

    private static class RetryContext<U> {
        private final long startedMillis = System.currentTimeMillis();
        private final long startedNanos = System.nanoTime();
        private final AtomicInteger count = new AtomicInteger();
        private final List<Throwable> thrown = new LinkedList<Throwable>();
        private final AtomicLong lastDelay = new AtomicLong();
        private final Supplier<U> supplier;

        RetryContext(Supplier<U> supplier) {
            this.supplier = supplier;
        }

        Throwable throwable() {
            if (this.thrown.isEmpty()) {
                return new IllegalStateException("Exception list is empty");
            }
            Throwable last = this.thrown.get(this.thrown.size() - 1);
            for (int i = 0; i < this.thrown.size() - 1; ++i) {
                Throwable throwable = this.thrown.get(i);
                if (throwable == last) continue;
                last.addSuppressed(throwable);
            }
            return last;
        }
    }
}

