/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Timeout;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class TimeoutImpl
implements Timeout {
    private final long timeoutMillis;
    private final LazyValue<? extends ScheduledExecutorService> executor;

    TimeoutImpl(Timeout.Builder builder) {
        this.timeoutMillis = builder.timeout().toMillis();
        this.executor = builder.executor();
    }

    @Override
    public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        return Multi.create(supplier.get()).timeout(this.timeoutMillis, TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.executor.get());
    }

    @Override
    public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        return Single.create(supplier.get()).timeout(this.timeoutMillis, TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.executor.get());
    }
}

