/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.Timeout;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

class TimeoutImpl
implements Timeout {
    private static final long MONITOR_THREAD_TIMEOUT = 100L;
    private final long timeoutMillis;
    private final LazyValue<? extends ScheduledExecutorService> executor;
    private final boolean currentThread;
    private final String name;

    TimeoutImpl(Timeout.Builder builder) {
        this.timeoutMillis = builder.timeout().toMillis();
        this.executor = builder.executor();
        this.currentThread = builder.currentThread();
        this.name = builder.name();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        if (this.currentThread) {
            throw new UnsupportedOperationException("Unsupported currentThread flag with Multi");
        }
        return Multi.create(supplier.get()).timeout(this.timeoutMillis, TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.executor.get());
    }

    @Override
    public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        if (!this.currentThread) {
            return Single.create(supplier.get(), (boolean)true).timeout(this.timeoutMillis, TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.executor.get());
        }
        Thread thisThread = Thread.currentThread();
        CompletableFuture monitorStarted = new CompletableFuture();
        AtomicBoolean callReturned = new AtomicBoolean(false);
        CompletableFuture future = new CompletableFuture();
        Timeout.builder().executor((ScheduledExecutorService)this.executor.get()).currentThread(false).timeout(Duration.ofMillis(this.timeoutMillis)).build().invoke(() -> {
            monitorStarted.complete(null);
            return Single.never();
        }).exceptionally(it -> {
            if (callReturned.compareAndSet(false, true)) {
                future.completeExceptionally(new TimeoutException("Method interrupted by timeout"));
                thisThread.interrupt();
            }
            return null;
        });
        try {
            monitorStarted.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return Single.error((Throwable)new IllegalStateException("Timeout monitor thread failed to start"));
        }
        Single single = Single.create(supplier.get(), (boolean)true);
        callReturned.set(true);
        single.whenComplete((o, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                future.complete(o);
            }
        });
        Thread.interrupted();
        return Single.create(future, (boolean)true);
    }
}

