/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.Fallback;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.faulttolerance.FtHandlerTyped;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.Timeout;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class FaultTolerance {
    private static final AtomicReference<LazyValue<? extends ScheduledExecutorService>> SCHEDULED_EXECUTOR = new AtomicReference();
    private static final AtomicReference<LazyValue<ExecutorService>> EXECUTOR = new AtomicReference();
    private static final AtomicReference<Config> CONFIG = new AtomicReference<Config>(Config.empty());
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    private FaultTolerance() {
    }

    public static void config(Config config) {
        CONFIG.set(config);
        SCHEDULED_EXECUTOR.set((LazyValue<? extends ScheduledExecutorService>)LazyValue.create((Supplier)ScheduledThreadPoolSupplier.create((Config)CONFIG.get().get("scheduled-executor"))));
        EXECUTOR.set((LazyValue<ExecutorService>)LazyValue.create((Supplier)ThreadPoolSupplier.create((Config)CONFIG.get().get("executor"), (String)"ft-se-thread-pool")));
    }

    public static void executor(Supplier<? extends ExecutorService> executor) {
        EXECUTOR.set((LazyValue<ExecutorService>)LazyValue.create(executor::get));
    }

    public static void scheduledExecutor(Supplier<? extends ScheduledExecutorService> executor) {
        SCHEDULED_EXECUTOR.set((LazyValue<? extends ScheduledExecutorService>)LazyValue.create(executor));
    }

    static LazyValue<? extends ExecutorService> executor() {
        INITIALIZED.set(true);
        return EXECUTOR.get();
    }

    static LazyValue<? extends ScheduledExecutorService> scheduledExecutor() {
        INITIALIZED.set(true);
        return SCHEDULED_EXECUTOR.get();
    }

    public static boolean initialized() {
        return INITIALIZED.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> TypedBuilder<T> typedBuilder() {
        return new TypedBuilder();
    }

    static Config config() {
        return CONFIG.get();
    }

    static Throwable cause(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return FaultTolerance.cause(throwable.getCause());
        }
        if (throwable instanceof ExecutionException) {
            return FaultTolerance.cause(throwable.getCause());
        }
        return throwable;
    }

    static <T> CompletableFuture<T> createDependency(CompletionStage<T> source, CompletableFuture<T> dependent, boolean cancelSource) {
        source.whenComplete((o, t) -> {
            if (t != null) {
                dependent.completeExceptionally((Throwable)t);
            } else {
                dependent.complete(o);
            }
        });
        if (cancelSource) {
            dependent.whenComplete((o, t) -> {
                if (dependent.isCancelled()) {
                    source.toCompletableFuture().cancel(true);
                }
            });
        }
        return dependent;
    }

    static {
        SCHEDULED_EXECUTOR.set((LazyValue<? extends ScheduledExecutorService>)LazyValue.create((Supplier)ScheduledThreadPoolSupplier.builder().threadNamePrefix("ft-schedule-").corePoolSize(2).config(CONFIG.get().get("scheduled-executor")).build()));
        EXECUTOR.set((LazyValue<ExecutorService>)LazyValue.create((Supplier)ThreadPoolSupplier.builder().threadNamePrefix("ft-").config(CONFIG.get().get("executor")).build()));
    }

    public static class Builder
    extends BaseBuilder<Builder>
    implements io.helidon.common.Builder<Builder, FtHandler> {
        private final List<FtHandler> fts = new LinkedList<FtHandler>();

        private Builder() {
        }

        public FtHandler build() {
            return new FtHandlerImpl(this.fts);
        }

        public <U> TypedBuilder<U> addFallback(Fallback<U> fallback) {
            return new TypedBuilder().builder(this).addFallback(fallback);
        }

        @Override
        public Builder add(FtHandler ft) {
            this.fts.add(ft);
            return this;
        }

        private static class FtHandlerImpl
        implements FtHandler {
            private final List<FtHandler> validFts;
            private final String name = "FtHandler-" + System.identityHashCode(this);

            private FtHandlerImpl(List<FtHandler> validFts) {
                this.validFts = new LinkedList<FtHandler>(validFts);
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public <T> Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
                Supplier<Flow.Publisher<T>> next = supplier;
                for (FtHandler validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invokeMulti(finalNext);
                }
                return Multi.create(next.get());
            }

            @Override
            public <T> Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
                Supplier<CompletionStage<T>> next = supplier;
                for (FtHandler validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invoke(finalNext);
                }
                return Single.create(next.get(), (boolean)true);
            }
        }
    }

    public static class TypedBuilder<T>
    extends BaseBuilder<TypedBuilder<T>>
    implements io.helidon.common.Builder<TypedBuilder<T>, FtHandlerTyped<T>> {
        private final List<FtHandlerTyped<T>> fts = new LinkedList<FtHandlerTyped<T>>();

        private TypedBuilder() {
        }

        public FtHandlerTyped<T> build() {
            return new FtHandlerTypedImpl<T>(this.fts);
        }

        @Override
        public TypedBuilder<T> add(FtHandler ft) {
            this.fts.add(new TypedWrapper(ft));
            return this;
        }

        public TypedBuilder<T> addFallback(Fallback<T> fallback) {
            this.fts.add(fallback);
            return this;
        }

        private TypedBuilder<T> builder(Builder builder) {
            builder.fts.forEach(it -> this.fts.add(new TypedWrapper((FtHandler)it)));
            return this;
        }

        private static class FtHandlerTypedImpl<T>
        implements FtHandlerTyped<T> {
            private final List<FtHandlerTyped<T>> validFts;

            private FtHandlerTypedImpl(List<FtHandlerTyped<T>> validFts) {
                this.validFts = new LinkedList<FtHandlerTyped<T>>(validFts);
            }

            @Override
            public Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
                Supplier<Flow.Publisher<T>> next = supplier;
                for (FtHandlerTyped validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invokeMulti(finalNext);
                }
                return Multi.create(next.get());
            }

            @Override
            public Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
                Supplier<CompletionStage<T>> next = supplier;
                for (FtHandlerTyped validFt : this.validFts) {
                    Supplier finalNext = next;
                    next = () -> validFt.invoke(finalNext);
                }
                return Single.create(next.get(), (boolean)true);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int i = this.validFts.size() - 1; i >= 0; --i) {
                    sb.append(this.validFts.get(i).toString());
                    sb.append("\n");
                }
                return sb.toString();
            }
        }

        private class TypedWrapper
        implements FtHandlerTyped<T> {
            private final FtHandler handler;

            private TypedWrapper(FtHandler handler) {
                this.handler = handler;
            }

            @Override
            public Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
                return this.handler.invoke(supplier);
            }

            @Override
            public Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
                return this.handler.invokeMulti(supplier);
            }

            public String toString() {
                return this.handler.getClass().getSimpleName();
            }
        }
    }

    static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        BaseBuilder() {
        }

        private B me() {
            return (B)this;
        }

        public B addBulkhead(Bulkhead bulkhead) {
            this.add(bulkhead);
            return this.me();
        }

        public B addBreaker(CircuitBreaker breaker) {
            this.add(breaker);
            return this.me();
        }

        public B addTimeout(Timeout timeout) {
            this.add(timeout);
            return this.me();
        }

        public B addRetry(Retry retry) {
            this.add(retry);
            return this.me();
        }

        public abstract B add(FtHandler var1);
    }
}

