/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.faulttolerance.TimeoutImpl;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

public interface Timeout
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public static Timeout create(Duration timeout) {
        return Timeout.builder().timeout(timeout).build();
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<Builder, Timeout> {
        private Duration timeout = Duration.ofSeconds(10L);
        private LazyValue<? extends ScheduledExecutorService> executor = FaultTolerance.scheduledExecutor();
        private boolean currentThread = false;
        private String name = "Timeout-" + System.identityHashCode(this);
        private boolean cancelSource = true;

        private Builder() {
        }

        public Timeout build() {
            return new TimeoutImpl(this);
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder currentThread(boolean currentThread) {
            this.currentThread = currentThread;
            return this;
        }

        public Builder executor(ScheduledExecutorService executor) {
            this.executor = LazyValue.create((Object)executor);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cancelSource(boolean cancelSource) {
            this.cancelSource = cancelSource;
            return this;
        }

        public Builder config(Config config) {
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("current-thread").asBoolean().ifPresent(this::currentThread);
            config.get("name").asString().ifPresent(this::name);
            config.get("cancel-source").asBoolean().ifPresent(this::cancelSource);
            return this;
        }

        Duration timeout() {
            return this.timeout;
        }

        LazyValue<? extends ScheduledExecutorService> executor() {
            return this.executor;
        }

        boolean currentThread() {
            return this.currentThread;
        }

        String name() {
            return this.name;
        }

        boolean cancelSource() {
            return this.cancelSource;
        }
    }
}

