/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.reactive.Multi;
import io.helidon.faulttolerance.FallbackImpl;
import io.helidon.faulttolerance.FtHandlerTyped;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;

public interface Fallback<T>
extends FtHandlerTyped<T> {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Fallback<T> create(Function<Throwable, ? extends CompletionStage<T>> fallback) {
        Builder<T> builder = Fallback.builder();
        return builder.fallback(fallback).build();
    }

    public static <T> Fallback<T> createMulti(Function<Throwable, ? extends Flow.Publisher<T>> fallback) {
        Builder<T> builder = Fallback.builder();
        return builder.fallbackMulti(fallback).build();
    }

    public static class Builder<T>
    implements io.helidon.common.Builder<Builder<T>, Fallback<T>> {
        private final Set<Class<? extends Throwable>> applyOn = new HashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new HashSet<Class<? extends Throwable>>();
        private Function<Throwable, ? extends CompletionStage<T>> fallback = CompletableFuture::failedFuture;
        private Function<Throwable, ? extends Flow.Publisher<T>> fallbackMulti = Multi::error;

        private Builder() {
        }

        public Fallback<T> build() {
            return new FallbackImpl(this);
        }

        public Builder<T> fallback(Function<Throwable, ? extends CompletionStage<T>> fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder<T> fallbackMulti(Function<Throwable, ? extends Flow.Publisher<T>> fallback) {
            this.fallbackMulti = fallback;
            return this;
        }

        @SafeVarargs
        public final Builder<T> applyOn(Class<? extends Throwable> ... classes) {
            this.applyOn.clear();
            Arrays.stream(classes).forEach(this::addApplyOn);
            return this;
        }

        public Builder<T> addApplyOn(Class<? extends Throwable> clazz) {
            this.applyOn.add(clazz);
            return this;
        }

        @SafeVarargs
        public final Builder<T> skipOn(Class<? extends Throwable> ... classes) {
            this.skipOn.clear();
            Arrays.stream(classes).forEach(this::addSkipOn);
            return this;
        }

        public Builder<T> addSkipOn(Class<? extends Throwable> clazz) {
            this.skipOn.add(clazz);
            return this;
        }

        Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        Function<Throwable, ? extends CompletionStage<T>> fallback() {
            return this.fallback;
        }

        Function<Throwable, ? extends Flow.Publisher<T>> fallbackMulti() {
            return this.fallbackMulti;
        }
    }
}

