/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import java.util.Set;

@FunctionalInterface
public interface ErrorChecker {
    public static ErrorChecker create(Set<Class<? extends Throwable>> skipOnSet, Set<Class<? extends Throwable>> applyOnSet) {
        Set<Class<? extends Throwable>> skipOn = Set.copyOf(skipOnSet);
        Set<Class<? extends Throwable>> applyOn = Set.copyOf(applyOnSet);
        return throwable -> ErrorChecker.containsThrowable(skipOn, throwable) || !applyOn.isEmpty() && !ErrorChecker.containsThrowable(applyOn, throwable);
    }

    public boolean shouldSkip(Throwable var1);

    private static boolean containsThrowable(Set<Class<? extends Throwable>> set, Throwable throwable) {
        return set.stream().anyMatch(t -> t.isAssignableFrom(throwable.getClass()));
    }
}

