/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.BulkheadConfig;
import io.helidon.inject.configdriven.api.ConfigBean;
import java.util.List;
import java.util.Optional;

@ConfigBean(repeatable=true)
@Prototype.Configured(value="fault-tolerance.bulkheads")
@Prototype.Blueprint(decorator=BuilderDecorator.class)
interface BulkheadConfigBlueprint
extends Prototype.Factory<Bulkhead> {
    public static final int DEFAULT_LIMIT = 10;
    public static final int DEFAULT_QUEUE_LENGTH = 10;

    @Option.Configured
    @Option.DefaultInt(value={10})
    public int limit();

    @Option.Configured
    @Option.DefaultInt(value={10})
    public int queueLength();

    @Option.Singular
    public List<Bulkhead.QueueListener> queueListeners();

    public Optional<String> name();

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<BulkheadConfig.BuilderBase<?, ?>> {
        public void decorate(BulkheadConfig.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.config().ifPresent(cfg -> target.name(cfg.name()));
            }
        }
    }
}

