/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.RetryConfigBlueprint;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.RetryConfigBlueprint")
public interface RetryConfig
extends RetryConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RetryConfig instance) {
        return (Builder)RetryConfig.builder().from(instance);
    }

    public static RetryConfig create(Config config) {
        return ((Builder)RetryConfig.builder().config(config)).buildPrototype();
    }

    public static RetryConfig create() {
        return RetryConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, RetryConfig>
    implements io.helidon.common.Builder<Builder, Retry> {
        private Builder() {
        }

        public RetryConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RetryConfigImpl(this);
        }

        public Retry build() {
            return Retry.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RetryConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<Class<? extends Throwable>> applyOn = new LinkedHashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new LinkedHashSet<Class<? extends Throwable>>();
        private Config config;
        private double delayFactor = -1.0;
        private Duration delay = Duration.parse("PT0.2S");
        private Duration jitter = Duration.parse("PT-1S");
        private Duration overallTimeout = Duration.parse("PT1S");
        private int calls = 3;
        private Retry.RetryPolicy retryPolicy;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(RetryConfig prototype) {
            this.name(prototype.name());
            this.calls(prototype.calls());
            this.delay(prototype.delay());
            this.delayFactor(prototype.delayFactor());
            this.jitter(prototype.jitter());
            this.overallTimeout(prototype.overallTimeout());
            this.addSkipOn(prototype.skipOn());
            this.addApplyOn(prototype.applyOn());
            this.retryPolicy(prototype.retryPolicy());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.calls(builder.calls());
            this.delay(builder.delay());
            this.delayFactor(builder.delayFactor());
            this.jitter(builder.jitter());
            this.overallTimeout(builder.overallTimeout());
            this.addSkipOn(builder.skipOn);
            this.addApplyOn(builder.applyOn);
            builder.retryPolicy().ifPresent(this::retryPolicy);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("calls").as(Integer.class).ifPresent(this::calls);
            config.get("delay").as(Duration.class).ifPresent(this::delay);
            config.get("delay-factor").as(Double.class).ifPresent(this::delayFactor);
            config.get("jitter").as(Duration.class).ifPresent(this::jitter);
            config.get("overall-timeout").as(Duration.class).ifPresent(this::overallTimeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER calls(int calls) {
            this.calls = calls;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delay(Duration delay) {
            Objects.requireNonNull(delay);
            this.delay = delay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delayFactor(double delayFactor) {
            this.delayFactor = delayFactor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER jitter(Duration jitter) {
            Objects.requireNonNull(jitter);
            this.jitter = jitter;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER overallTimeout(Duration overallTimeout) {
            Objects.requireNonNull(overallTimeout);
            this.overallTimeout = overallTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER skipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.clear();
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Class<? extends Throwable> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.add(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER applyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.clear();
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Class<? extends Throwable> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.add(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRetryPolicy() {
            this.retryPolicy = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER retryPolicy(Retry.RetryPolicy retryPolicy) {
            Objects.requireNonNull(retryPolicy);
            this.retryPolicy = retryPolicy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public int calls() {
            return this.calls;
        }

        public Duration delay() {
            return this.delay;
        }

        public double delayFactor() {
            return this.delayFactor;
        }

        public Duration jitter() {
            return this.jitter;
        }

        public Duration overallTimeout() {
            return this.overallTimeout;
        }

        public Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        public Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        public Optional<Retry.RetryPolicy> retryPolicy() {
            return Optional.ofNullable(this.retryPolicy);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "RetryConfigBuilder{name=" + this.name + ",calls=" + this.calls + ",delay=" + String.valueOf(this.delay) + ",delayFactor=" + this.delayFactor + ",jitter=" + String.valueOf(this.jitter) + ",overallTimeout=" + String.valueOf(this.overallTimeout) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + ",retryPolicy=" + String.valueOf(this.retryPolicy) + "}";
        }

        protected void preBuildPrototype() {
            new RetryConfigBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER retryPolicy(Optional<? extends Retry.RetryPolicy> retryPolicy) {
            Objects.requireNonNull(retryPolicy);
            this.retryPolicy = retryPolicy.map(Retry.RetryPolicy.class::cast).orElse(this.retryPolicy);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class RetryConfigImpl
        implements RetryConfig,
        Supplier<Retry> {
            private final double delayFactor;
            private final Duration delay;
            private final Duration jitter;
            private final Duration overallTimeout;
            private final int calls;
            private final Optional<Retry.RetryPolicy> retryPolicy;
            private final Optional<String> name;
            private final Set<Class<? extends Throwable>> applyOn;
            private final Set<Class<? extends Throwable>> skipOn;

            protected RetryConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.calls = builder.calls();
                this.delay = builder.delay();
                this.delayFactor = builder.delayFactor();
                this.jitter = builder.jitter();
                this.overallTimeout = builder.overallTimeout();
                this.skipOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.skipOn()));
                this.applyOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.applyOn()));
                this.retryPolicy = builder.retryPolicy();
            }

            public Retry build() {
                return Retry.create(this);
            }

            @Override
            public Retry get() {
                return this.build();
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public int calls() {
                return this.calls;
            }

            @Override
            public Duration delay() {
                return this.delay;
            }

            @Override
            public double delayFactor() {
                return this.delayFactor;
            }

            @Override
            public Duration jitter() {
                return this.jitter;
            }

            @Override
            public Duration overallTimeout() {
                return this.overallTimeout;
            }

            @Override
            public Set<Class<? extends Throwable>> skipOn() {
                return this.skipOn;
            }

            @Override
            public Set<Class<? extends Throwable>> applyOn() {
                return this.applyOn;
            }

            @Override
            public Optional<Retry.RetryPolicy> retryPolicy() {
                return this.retryPolicy;
            }

            public String toString() {
                return "RetryConfig{name=" + String.valueOf(this.name) + ",calls=" + this.calls + ",delay=" + String.valueOf(this.delay) + ",delayFactor=" + this.delayFactor + ",jitter=" + String.valueOf(this.jitter) + ",overallTimeout=" + String.valueOf(this.overallTimeout) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + ",retryPolicy=" + String.valueOf(this.retryPolicy) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RetryConfig)) {
                    return false;
                }
                RetryConfig other = (RetryConfig)o;
                return Objects.equals(this.name, other.name()) && this.calls == other.calls() && Objects.equals(this.delay, other.delay()) && this.delayFactor == other.delayFactor() && Objects.equals(this.jitter, other.jitter()) && Objects.equals(this.overallTimeout, other.overallTimeout()) && Objects.equals(this.skipOn, other.skipOn()) && Objects.equals(this.applyOn, other.applyOn()) && Objects.equals(this.retryPolicy, other.retryPolicy());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.calls, this.delay, this.delayFactor, this.jitter, this.overallTimeout, this.skipOn, this.applyOn, this.retryPolicy);
            }
        }
    }
}

