/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.AsyncConfigBlueprint;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.AsyncConfigBlueprint")
public interface AsyncConfig
extends AsyncConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AsyncConfig instance) {
        return (Builder)AsyncConfig.builder().from(instance);
    }

    public static AsyncConfig create(Config config) {
        return ((Builder)AsyncConfig.builder().config(config)).buildPrototype();
    }

    public static AsyncConfig create() {
        return AsyncConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, AsyncConfig>
    implements io.helidon.common.Builder<Builder, Async> {
        private Builder() {
        }

        public AsyncConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AsyncConfigImpl(this);
        }

        public Async build() {
            return Async.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends AsyncConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private CompletableFuture<Async> onStart;
        private Config config;
        private ExecutorService executor;
        private String executorName;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(AsyncConfig prototype) {
            this.name(prototype.name());
            this.executorName(prototype.executorName());
            this.executor(prototype.executor());
            this.onStart(prototype.onStart());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            builder.executorName().ifPresent(this::executorName);
            builder.executor().ifPresent(this::executor);
            builder.onStart().ifPresent(this::onStart);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("executor-name").as(String.class).ifPresent(this::executorName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExecutorName() {
            this.executorName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executorName(String executorName) {
            Objects.requireNonNull(executorName);
            this.executorName = executorName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExecutor() {
            this.executor = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOnStart() {
            this.onStart = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER onStart(CompletableFuture<Async> onStart) {
            Objects.requireNonNull(onStart);
            this.onStart = onStart;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> executorName() {
            return Optional.ofNullable(this.executorName);
        }

        public Optional<ExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public Optional<CompletableFuture<Async>> onStart() {
            return Optional.ofNullable(this.onStart);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "AsyncConfigBuilder{name=" + this.name + ",executorName=" + this.executorName + ",executor=" + String.valueOf(this.executor) + ",onStart=" + String.valueOf(this.onStart) + "}";
        }

        protected void preBuildPrototype() {
            new AsyncConfigBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER executorName(Optional<String> executorName) {
            Objects.requireNonNull(executorName);
            this.executorName = executorName.map(String.class::cast).orElse(this.executorName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER executor(Optional<? extends ExecutorService> executor) {
            Objects.requireNonNull(executor);
            this.executor = executor.map(ExecutorService.class::cast).orElse(this.executor);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER onStart(Optional<CompletableFuture<Async>> onStart) {
            Objects.requireNonNull(onStart);
            this.onStart = onStart.map(CompletableFuture.class::cast).orElse(this.onStart);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class AsyncConfigImpl
        implements AsyncConfig,
        Supplier<Async> {
            private final Optional<String> executorName;
            private final Optional<String> name;
            private final Optional<CompletableFuture<Async>> onStart;
            private final Optional<ExecutorService> executor;

            protected AsyncConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.executorName = builder.executorName();
                this.executor = builder.executor();
                this.onStart = builder.onStart();
            }

            public Async build() {
                return Async.create(this);
            }

            @Override
            public Async get() {
                return this.build();
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public Optional<String> executorName() {
                return this.executorName;
            }

            @Override
            public Optional<ExecutorService> executor() {
                return this.executor;
            }

            @Override
            public Optional<CompletableFuture<Async>> onStart() {
                return this.onStart;
            }

            public String toString() {
                return "AsyncConfig{name=" + String.valueOf(this.name) + ",executorName=" + String.valueOf(this.executorName) + ",executor=" + String.valueOf(this.executor) + ",onStart=" + String.valueOf(this.onStart) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AsyncConfig)) {
                    return false;
                }
                AsyncConfig other = (AsyncConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.executorName, other.executorName()) && Objects.equals(this.executor, other.executor()) && Objects.equals(this.onStart, other.onStart());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.executorName, this.executor, this.onStart);
            }
        }
    }
}

