/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.CircuitBreakerConfig;
import io.helidon.faulttolerance.CircuitBreakerConfigBlueprint;
import io.helidon.faulttolerance.CircuitBreakerOpenException;
import io.helidon.faulttolerance.ErrorChecker;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.ResultWindow;
import io.helidon.faulttolerance.SupplierHelper;
import io.helidon.inject.configdriven.api.ConfigDriven;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

@ConfigDriven(value=CircuitBreakerConfigBlueprint.class)
class CircuitBreakerImpl
implements CircuitBreaker {
    private final ExecutorService executor;
    private final long delayMillis;
    private final int successThreshold;
    private final AtomicReference<CircuitBreaker.State> state = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private final ResultWindow results;
    private final AtomicInteger successCounter = new AtomicInteger();
    private final AtomicBoolean halfOpenInProgress = new AtomicBoolean();
    private final AtomicReference<Future<Boolean>> schedule = new AtomicReference();
    private final ErrorChecker errorChecker;
    private final String name;
    private final CircuitBreakerConfig config;

    @Inject
    CircuitBreakerImpl(CircuitBreakerConfig config) {
        this.delayMillis = config.delay().toMillis();
        this.successThreshold = config.successThreshold();
        this.results = new ResultWindow(config.volume(), config.errorRatio());
        this.executor = config.executor().orElseGet((Supplier<ExecutorService>)FaultTolerance.executor());
        this.errorChecker = ErrorChecker.create(config.skipOn(), config.applyOn());
        this.name = config.name().orElseGet(() -> "circuit-breaker-" + System.identityHashCode(config));
        this.config = config;
    }

    public CircuitBreakerConfig prototype() {
        return this.config;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> T invoke(Supplier<? extends T> supplier) {
        return switch (this.state.get()) {
            default -> throw new MatchException(null, null);
            case CircuitBreaker.State.CLOSED -> this.executeTask(supplier);
            case CircuitBreaker.State.HALF_OPEN -> this.halfOpenTask(supplier);
            case CircuitBreaker.State.OPEN -> throw new CircuitBreakerOpenException("CircuitBreaker is open");
        };
    }

    @Override
    public CircuitBreaker.State state() {
        return this.state.get();
    }

    @Override
    public void state(CircuitBreaker.State newState) {
        if (newState == CircuitBreaker.State.CLOSED) {
            if (this.state.get() == CircuitBreaker.State.CLOSED) {
                this.resetCounters();
                return;
            }
            Future future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
            this.state.set(CircuitBreaker.State.CLOSED);
        } else if (newState == CircuitBreaker.State.OPEN) {
            this.state.set(CircuitBreaker.State.OPEN);
            Future future = this.schedule.getAndSet(null);
            if (future != null) {
                future.cancel(false);
            }
            this.resetCounters();
        } else {
            this.resetCounters();
        }
    }

    Future<Boolean> schedule() {
        return this.schedule.get();
    }

    private <U> U executeTask(Supplier<? extends U> supplier) {
        try {
            U result = supplier.get();
            this.results.update(ResultWindow.Result.SUCCESS);
            U u = result;
            return u;
        }
        catch (Throwable t) {
            Throwable throwable = SupplierHelper.unwrapThrowable(t);
            if (this.errorChecker.shouldSkip(throwable)) {
                this.results.update(ResultWindow.Result.SUCCESS);
            } else {
                this.results.update(ResultWindow.Result.FAILURE);
            }
            throw SupplierHelper.toRuntimeException(throwable);
        }
        finally {
            if (this.results.shouldOpen() && this.state.compareAndSet(CircuitBreaker.State.CLOSED, CircuitBreaker.State.OPEN)) {
                this.results.reset();
                this.scheduleHalf();
            }
        }
    }

    private <U> U halfOpenTask(Supplier<? extends U> supplier) {
        if (this.halfOpenInProgress.compareAndSet(false, true)) {
            try {
                U result = supplier.get();
                int successes = this.successCounter.incrementAndGet();
                if (successes >= this.successThreshold) {
                    this.successCounter.set(0);
                    this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED);
                }
                U u = result;
                return u;
            }
            catch (Throwable t) {
                Throwable throwable = SupplierHelper.unwrapThrowable(t);
                if (this.errorChecker.shouldSkip(throwable)) {
                    int successes = this.successCounter.incrementAndGet();
                    if (successes >= this.successThreshold) {
                        this.successCounter.set(0);
                        this.state.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED);
                    }
                } else {
                    this.successCounter.set(0);
                    this.state.set(CircuitBreaker.State.OPEN);
                    this.scheduleHalf();
                }
                throw SupplierHelper.toRuntimeException(throwable);
            }
            finally {
                this.halfOpenInProgress.set(false);
            }
        }
        throw new CircuitBreakerOpenException("CircuitBreaker is half open, parallel execution in progress");
    }

    private void scheduleHalf() {
        this.schedule.set(this.executor.submit(FaultTolerance.toDelayedCallable(() -> {
            this.state.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN);
            this.schedule.set(null);
            return true;
        }, this.delayMillis)));
    }

    private void resetCounters() {
        this.results.reset();
        this.successCounter.set(0);
    }
}

