/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.faulttolerance.CircuitBreaker;
import io.helidon.faulttolerance.CircuitBreakerConfigBlueprint;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.CircuitBreakerConfigBlueprint")
public interface CircuitBreakerConfig
extends CircuitBreakerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CircuitBreakerConfig instance) {
        return (Builder)CircuitBreakerConfig.builder().from(instance);
    }

    public static CircuitBreakerConfig create(Config config) {
        return ((Builder)CircuitBreakerConfig.builder().config(config)).buildPrototype();
    }

    public static CircuitBreakerConfig create() {
        return CircuitBreakerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, CircuitBreakerConfig>
    implements io.helidon.common.Builder<Builder, CircuitBreaker> {
        private Builder() {
        }

        public CircuitBreakerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.CircuitBreakerConfigImpl(this);
        }

        public CircuitBreaker build() {
            return CircuitBreaker.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends CircuitBreakerConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Set<Class<? extends Throwable>> applyOn = new LinkedHashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new LinkedHashSet<Class<? extends Throwable>>();
        private Config config;
        private Duration delay = Duration.parse("PT5S");
        private ExecutorService executor;
        private int errorRatio = 60;
        private int successThreshold = 1;
        private int volume = 10;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(CircuitBreakerConfig prototype) {
            this.name(prototype.name());
            this.delay(prototype.delay());
            this.errorRatio(prototype.errorRatio());
            this.volume(prototype.volume());
            this.successThreshold(prototype.successThreshold());
            this.executor(prototype.executor());
            this.addSkipOn(prototype.skipOn());
            this.addApplyOn(prototype.applyOn());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.delay(builder.delay());
            this.errorRatio(builder.errorRatio());
            this.volume(builder.volume());
            this.successThreshold(builder.successThreshold());
            builder.executor().ifPresent(this::executor);
            this.addSkipOn(builder.skipOn);
            this.addApplyOn(builder.applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("delay").as(Duration.class).ifPresent(this::delay);
            config.get("error-ratio").as(Integer.class).ifPresent(this::errorRatio);
            config.get("volume").as(Integer.class).ifPresent(this::volume);
            config.get("success-threshold").as(Integer.class).ifPresent(this::successThreshold);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER delay(Duration delay) {
            Objects.requireNonNull(delay);
            this.delay = delay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER errorRatio(int errorRatio) {
            this.errorRatio = errorRatio;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER volume(int volume) {
            this.volume = volume;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER successThreshold(int successThreshold) {
            this.successThreshold = successThreshold;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExecutor() {
            this.executor = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER skipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.clear();
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Class<? extends Throwable> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.add(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER applyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.clear();
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Class<? extends Throwable> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.add(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Duration delay() {
            return this.delay;
        }

        public int errorRatio() {
            return this.errorRatio;
        }

        public int volume() {
            return this.volume;
        }

        public int successThreshold() {
            return this.successThreshold;
        }

        public Optional<ExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        public Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "CircuitBreakerConfigBuilder{name=" + this.name + ",delay=" + String.valueOf(this.delay) + ",errorRatio=" + this.errorRatio + ",volume=" + this.volume + ",successThreshold=" + this.successThreshold + ",executor=" + String.valueOf(this.executor) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + "}";
        }

        protected void preBuildPrototype() {
            new CircuitBreakerConfigBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER executor(Optional<? extends ExecutorService> executor) {
            Objects.requireNonNull(executor);
            this.executor = executor.map(ExecutorService.class::cast).orElse(this.executor);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class CircuitBreakerConfigImpl
        implements CircuitBreakerConfig,
        Supplier<CircuitBreaker> {
            private final Duration delay;
            private final int errorRatio;
            private final int successThreshold;
            private final int volume;
            private final Optional<String> name;
            private final Optional<ExecutorService> executor;
            private final Set<Class<? extends Throwable>> applyOn;
            private final Set<Class<? extends Throwable>> skipOn;

            protected CircuitBreakerConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.delay = builder.delay();
                this.errorRatio = builder.errorRatio();
                this.volume = builder.volume();
                this.successThreshold = builder.successThreshold();
                this.executor = builder.executor();
                this.skipOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.skipOn()));
                this.applyOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.applyOn()));
            }

            public CircuitBreaker build() {
                return CircuitBreaker.create(this);
            }

            @Override
            public CircuitBreaker get() {
                return this.build();
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public Duration delay() {
                return this.delay;
            }

            @Override
            public int errorRatio() {
                return this.errorRatio;
            }

            @Override
            public int volume() {
                return this.volume;
            }

            @Override
            public int successThreshold() {
                return this.successThreshold;
            }

            @Override
            public Optional<ExecutorService> executor() {
                return this.executor;
            }

            @Override
            public Set<Class<? extends Throwable>> skipOn() {
                return this.skipOn;
            }

            @Override
            public Set<Class<? extends Throwable>> applyOn() {
                return this.applyOn;
            }

            public String toString() {
                return "CircuitBreakerConfig{name=" + String.valueOf(this.name) + ",delay=" + String.valueOf(this.delay) + ",errorRatio=" + this.errorRatio + ",volume=" + this.volume + ",successThreshold=" + this.successThreshold + ",executor=" + String.valueOf(this.executor) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CircuitBreakerConfig)) {
                    return false;
                }
                CircuitBreakerConfig other = (CircuitBreakerConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.delay, other.delay()) && this.errorRatio == other.errorRatio() && this.volume == other.volume() && this.successThreshold == other.successThreshold() && Objects.equals(this.executor, other.executor()) && Objects.equals(this.skipOn, other.skipOn()) && Objects.equals(this.applyOn, other.applyOn());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.delay, this.errorRatio, this.volume, this.successThreshold, this.executor, this.skipOn, this.applyOn);
            }
        }
    }
}

