/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.faulttolerance.FallbackConfigBlueprint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.FallbackConfigBlueprint<T>")
public interface FallbackConfig<T>
extends FallbackConfigBlueprint<T>,
Prototype.Api {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(FallbackConfig<T> instance) {
        return (Builder)FallbackConfig.builder().from(instance);
    }

    public static <T> FallbackConfig<T> create() {
        return FallbackConfig.builder().buildPrototype();
    }

    public static class Builder<T>
    extends BuilderBase<T, Builder<T>, FallbackConfig<T>>
    implements io.helidon.common.Builder<Builder<T>, FallbackConfig<T>> {
        private Builder() {
        }

        public FallbackConfig<T> buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FallbackConfigImpl(this);
        }

        public FallbackConfig<T> build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<T, BUILDER extends BuilderBase<T, BUILDER, PROTOTYPE>, PROTOTYPE extends FallbackConfig<T>>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Class<? extends Throwable>> applyOn = new LinkedHashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new LinkedHashSet<Class<? extends Throwable>>();
        private Function<Throwable, ? extends T> fallback;

        protected BuilderBase() {
        }

        public BUILDER from(FallbackConfig<T> prototype) {
            this.fallback(prototype.fallback());
            this.addSkipOn(prototype.skipOn());
            this.addApplyOn(prototype.applyOn());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<T, ?, ?> builder) {
            builder.fallback().ifPresent(this::fallback);
            this.addSkipOn(builder.skipOn);
            this.addApplyOn(builder.applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fallback(Function<Throwable, ? extends T> fallback) {
            Objects.requireNonNull(fallback);
            this.fallback = fallback;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER skipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.clear();
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Set<Class<? extends Throwable>> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.addAll(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSkipOn(Class<? extends Throwable> skipOn) {
            Objects.requireNonNull(skipOn);
            this.skipOn.add(skipOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER applyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.clear();
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Set<Class<? extends Throwable>> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.addAll(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addApplyOn(Class<? extends Throwable> applyOn) {
            Objects.requireNonNull(applyOn);
            this.applyOn.add(applyOn);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Function<Throwable, ? extends T>> fallback() {
            return Optional.ofNullable(this.fallback);
        }

        public Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        public Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        public String toString() {
            return "FallbackConfigBuilder{fallback=" + String.valueOf(this.fallback) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.fallback == null) {
                collector.fatal(this.getClass(), "Property \"fallback\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class FallbackConfigImpl<T>
        implements FallbackConfig<T> {
            private final Function<Throwable, ? extends T> fallback;
            private final Set<Class<? extends Throwable>> applyOn;
            private final Set<Class<? extends Throwable>> skipOn;

            protected FallbackConfigImpl(BuilderBase<T, ?, ?> builder) {
                this.fallback = builder.fallback().get();
                this.skipOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.skipOn()));
                this.applyOn = Collections.unmodifiableSet(new LinkedHashSet<Class<Throwable>>(builder.applyOn()));
            }

            @Override
            public Function<Throwable, ? extends T> fallback() {
                return this.fallback;
            }

            @Override
            public Set<Class<? extends Throwable>> skipOn() {
                return this.skipOn;
            }

            @Override
            public Set<Class<? extends Throwable>> applyOn() {
                return this.applyOn;
            }

            public String toString() {
                return "FallbackConfig{fallback=" + String.valueOf(this.fallback) + ",skipOn=" + String.valueOf(this.skipOn) + ",applyOn=" + String.valueOf(this.applyOn) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FallbackConfig)) {
                    return false;
                }
                FallbackConfig other = (FallbackConfig)o;
                return Objects.equals(this.fallback, other.fallback()) && Objects.equals(this.skipOn, other.skipOn()) && Objects.equals(this.applyOn, other.applyOn());
            }

            public int hashCode() {
                return Objects.hash(this.fallback, this.skipOn, this.applyOn);
            }
        }
    }
}

