/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.faulttolerance.Bulkhead;
import io.helidon.faulttolerance.BulkheadConfigBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.BulkheadConfigBlueprint")
public interface BulkheadConfig
extends BulkheadConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BulkheadConfig instance) {
        return (Builder)BulkheadConfig.builder().from(instance);
    }

    public static BulkheadConfig create(Config config) {
        return ((Builder)BulkheadConfig.builder().config(config)).buildPrototype();
    }

    public static BulkheadConfig create() {
        return BulkheadConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, BulkheadConfig>
    implements io.helidon.common.Builder<Builder, Bulkhead> {
        private Builder() {
        }

        public BulkheadConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.BulkheadConfigImpl(this);
        }

        public Bulkhead build() {
            return Bulkhead.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends BulkheadConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<Bulkhead.QueueListener> queueListeners = new ArrayList<Bulkhead.QueueListener>();
        private boolean enableMetrics = false;
        private boolean isQueueListenersMutated;
        private Config config;
        private int limit = 10;
        private int queueLength = 10;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(BulkheadConfig prototype) {
            this.limit(prototype.limit());
            this.queueLength(prototype.queueLength());
            if (!this.isQueueListenersMutated) {
                this.queueListeners.clear();
            }
            this.addQueueListeners(prototype.queueListeners());
            this.name(prototype.name());
            this.enableMetrics(prototype.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.limit(builder.limit());
            this.queueLength(builder.queueLength());
            if (this.isQueueListenersMutated) {
                if (builder.isQueueListenersMutated) {
                    this.addQueueListeners(builder.queueListeners);
                }
            } else {
                this.queueListeners.clear();
                this.addQueueListeners(builder.queueListeners);
            }
            builder.name().ifPresent(this::name);
            this.enableMetrics(builder.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("limit").as(Integer.class).ifPresent(this::limit);
            config.get("queue-length").as(Integer.class).ifPresent(this::queueLength);
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER limit(int limit) {
            this.limit = limit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueLength(int queueLength) {
            this.queueLength = queueLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueListeners(List<? extends Bulkhead.QueueListener> queueListeners) {
            Objects.requireNonNull(queueListeners);
            this.isQueueListenersMutated = true;
            this.queueListeners.clear();
            this.queueListeners.addAll(queueListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueueListeners(List<? extends Bulkhead.QueueListener> queueListeners) {
            Objects.requireNonNull(queueListeners);
            this.isQueueListenersMutated = true;
            this.queueListeners.addAll(queueListeners);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQueueListener(Bulkhead.QueueListener queueListener) {
            Objects.requireNonNull(queueListener);
            this.queueListeners.add(queueListener);
            this.isQueueListenersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public int limit() {
            return this.limit;
        }

        public int queueLength() {
            return this.queueLength;
        }

        public List<Bulkhead.QueueListener> queueListeners() {
            return this.queueListeners;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "BulkheadConfigBuilder{limit=" + this.limit + ",queueLength=" + this.queueLength + ",queueListeners=" + String.valueOf(this.queueListeners) + ",name=" + this.name + ",enableMetrics=" + this.enableMetrics + "}";
        }

        protected void preBuildPrototype() {
            new BulkheadConfigBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class BulkheadConfigImpl
        implements BulkheadConfig,
        Supplier<Bulkhead> {
            private final boolean enableMetrics;
            private final int limit;
            private final int queueLength;
            private final List<Bulkhead.QueueListener> queueListeners;
            private final Optional<String> name;

            protected BulkheadConfigImpl(BuilderBase<?, ?> builder) {
                this.limit = builder.limit();
                this.queueLength = builder.queueLength();
                this.queueListeners = List.copyOf(builder.queueListeners());
                this.name = builder.name();
                this.enableMetrics = builder.enableMetrics();
            }

            public Bulkhead build() {
                return Bulkhead.create(this);
            }

            @Override
            public Bulkhead get() {
                return this.build();
            }

            @Override
            public int limit() {
                return this.limit;
            }

            @Override
            public int queueLength() {
                return this.queueLength;
            }

            @Override
            public List<Bulkhead.QueueListener> queueListeners() {
                return this.queueListeners;
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            public String toString() {
                return "BulkheadConfig{limit=" + this.limit + ",queueLength=" + this.queueLength + ",queueListeners=" + String.valueOf(this.queueListeners) + ",name=" + String.valueOf(this.name) + ",enableMetrics=" + this.enableMetrics + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BulkheadConfig)) {
                    return false;
                }
                BulkheadConfig other = (BulkheadConfig)o;
                return this.limit == other.limit() && this.queueLength == other.queueLength() && Objects.equals(this.queueListeners, other.queueListeners()) && Objects.equals(this.name, other.name()) && this.enableMetrics == other.enableMetrics();
            }

            public int hashCode() {
                return Objects.hash(this.limit, this.queueLength, this.queueListeners, this.name, this.enableMetrics);
            }
        }
    }
}

