/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.faulttolerance.Retry;
import io.helidon.faulttolerance.RetryConfig;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(decorator=BuilderDecorator.class)
@Prototype.Configured(value="fault-tolerance.retries")
interface RetryConfigBlueprint
extends Prototype.Factory<Retry> {
    public static final int DEFAULT_CALLS = 3;
    public static final Duration DEFAULT_DELAY = Duration.ofMillis(200L);
    public static final Duration DEFAULT_OVERALL_TIMEOUT = Duration.ofSeconds(1L);

    public Optional<String> name();

    @Option.Configured
    @Option.DefaultInt(value={3})
    public int calls();

    @Option.Configured
    @Option.Default(value={"PT0.2S"})
    public Duration delay();

    @Option.Configured
    @Option.DefaultDouble(value={-1.0})
    public double delayFactor();

    @Option.Configured
    @Option.Default(value={"PT-1S"})
    public Duration jitter();

    @Option.Configured
    @Option.Default(value={"PT1S"})
    public Duration overallTimeout();

    @Option.Singular
    public Set<Class<? extends Throwable>> skipOn();

    @Option.Singular
    public Set<Class<? extends Throwable>> applyOn();

    public Optional<Retry.RetryPolicy> retryPolicy();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean enableMetrics();

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<RetryConfig.BuilderBase<?, ?>> {
        public void decorate(RetryConfig.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.config().ifPresent(cfg -> target.name(cfg.name()));
            }
            if (target.retryPolicy().isEmpty()) {
                target.retryPolicy(this.retryPolicy(target));
            }
        }

        private Retry.RetryPolicy retryPolicy(RetryConfig.BuilderBase<?, ?> target) {
            if (target.jitter().toSeconds() == -1L) {
                Retry.DelayingRetryPolicy.Builder delayBuilder = Retry.DelayingRetryPolicy.builder().calls(target.calls()).delay(target.delay());
                if (target.delayFactor() != -1.0) {
                    delayBuilder.delayFactor(target.delayFactor());
                }
                return delayBuilder.build();
            }
            if (target.delayFactor() != -1.0) {
                return Retry.DelayingRetryPolicy.builder().calls(target.calls()).delayFactor(target.delayFactor()).delay(target.delay()).build();
            }
            return Retry.JitterRetryPolicy.builder().calls(target.calls()).delay(target.delay()).jitter(target.jitter()).build();
        }
    }
}

