/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.faulttolerance.Timeout;
import io.helidon.faulttolerance.TimeoutConfig;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Prototype.Blueprint(decorator=BuilderDecorator.class)
@Prototype.Configured(value="fault-tolerance.timeouts")
interface TimeoutConfigBlueprint
extends Prototype.Factory<Timeout> {
    public Optional<String> name();

    @Option.Configured
    @Option.Default(value={"PT10S"})
    public Duration timeout();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean currentThread();

    public Optional<ExecutorService> executor();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean enableMetrics();

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<TimeoutConfig.BuilderBase<?, ?>> {
        public void decorate(TimeoutConfig.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.config().ifPresent(cfg -> target.name(cfg.name()));
            }
        }
    }
}

