/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.MetricsUtils;
import io.helidon.faulttolerance.SupplierHelper;
import io.helidon.faulttolerance.Timeout;
import io.helidon.faulttolerance.TimeoutConfig;
import io.helidon.faulttolerance.TimeoutException;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class TimeoutImpl
implements Timeout {
    private static final System.Logger LOGGER = System.getLogger(TimeoutImpl.class.getName());
    private final long timeoutMillis;
    private final ExecutorService executor;
    private final boolean currentThread;
    private final String name;
    private final TimeoutConfig config;
    private final boolean metricsEnabled;
    private Counter callsCounterMetric;
    private Timer executionDurationMetric;

    TimeoutImpl(TimeoutConfig config) {
        this.timeoutMillis = config.timeout().toMillis();
        this.executor = config.executor().orElseGet((Supplier<ExecutorService>)FaultTolerance.executor());
        this.currentThread = config.currentThread();
        this.name = config.name().orElseGet(() -> "timeout-" + System.identityHashCode(config));
        this.config = config;
        boolean bl = this.metricsEnabled = config.enableMetrics() || MetricsUtils.defaultEnabled();
        if (this.metricsEnabled) {
            Tag nameTag = Tag.create((String)"name", (String)this.name);
            this.callsCounterMetric = MetricsUtils.counterBuilder("ft.timeout.calls.total", nameTag);
            this.executionDurationMetric = MetricsUtils.timerBuilder("ft.timeout.executionDuration", nameTag);
        }
    }

    public TimeoutConfig prototype() {
        return this.config;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(Supplier<? extends T> supplier) {
        long start;
        if (this.metricsEnabled) {
            this.callsCounterMetric.increment();
        }
        long l = start = this.metricsEnabled ? System.nanoTime() : 0L;
        if (!this.currentThread) {
            try {
                T t = CompletableFuture.supplyAsync(supplier, this.executor).orTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).get();
                return t;
            }
            catch (Throwable t) {
                throw TimeoutImpl.mapThrowable(t, null);
            }
            finally {
                if (this.metricsEnabled) {
                    this.executionDurationMetric.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                }
            }
        }
        Thread thisThread = Thread.currentThread();
        ReentrantLock interruptLock = new ReentrantLock();
        AtomicBoolean callReturned = new AtomicBoolean(false);
        AtomicBoolean interrupted = new AtomicBoolean(false);
        this.executor.submit(FaultTolerance.toDelayedRunnable(() -> {
            interruptLock.lock();
            try {
                if (callReturned.compareAndSet(false, true)) {
                    thisThread.interrupt();
                    interrupted.set(true);
                }
            }
            finally {
                interruptLock.unlock();
            }
        }, this.timeoutMillis));
        try {
            T result = supplier.get();
            if (interrupted.get()) {
                throw new TimeoutException("Supplier execution interrupted", null);
            }
            T t = result;
            return t;
        }
        catch (Throwable t) {
            throw TimeoutImpl.mapThrowable(t, interrupted);
        }
        finally {
            if (this.metricsEnabled) {
                this.executionDurationMetric.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
            interruptLock.lock();
            try {
                callReturned.set(true);
                if (Thread.interrupted()) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Current thread interrupted, clearing status");
                }
            }
            finally {
                interruptLock.unlock();
            }
        }
    }

    private static RuntimeException mapThrowable(Throwable t, AtomicBoolean interrupted) {
        Throwable throwable = SupplierHelper.unwrapThrowable(t);
        if (throwable instanceof InterruptedException) {
            return new TimeoutException("Call interrupted", throwable);
        }
        if (throwable instanceof java.util.concurrent.TimeoutException) {
            return new TimeoutException("Timeout reached", throwable.getCause());
        }
        if (interrupted != null && interrupted.get()) {
            return new TimeoutException("Supplier execution interrupted", t);
        }
        return SupplierHelper.toRuntimeException(throwable);
    }
}

