/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.client;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.helidon.grpc.client.ClientMethodDescriptor;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.PriorityBag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ClientServiceDescriptor {
    private String serviceName;
    private Map<String, ClientMethodDescriptor> methods;
    private PriorityBag<ClientInterceptor> interceptors;
    private CallCredentials callCredentials;

    private ClientServiceDescriptor(String serviceName, Map<String, ClientMethodDescriptor> methods, PriorityBag<ClientInterceptor> interceptors, CallCredentials callCredentials) {
        this.serviceName = serviceName;
        this.methods = methods;
        this.interceptors = interceptors;
        this.callCredentials = callCredentials;
    }

    public static ClientServiceDescriptor create(ServiceDescriptor descriptor) {
        return ClientServiceDescriptor.builder(descriptor).build();
    }

    public static ClientServiceDescriptor create(BindableService service) {
        return ClientServiceDescriptor.builder(service).build();
    }

    public static Builder builder(ServiceDescriptor service) {
        return new Builder(service);
    }

    public static Builder builder(BindableService service) {
        return new Builder(service);
    }

    public static Builder builder(Class<?> serviceClass) {
        try {
            Method method = serviceClass.getMethod("getServiceDescriptor", new Class[0]);
            if (method.getReturnType() == ServiceDescriptor.class) {
                ServiceDescriptor svcDesc = (ServiceDescriptor)method.invoke(null, new Object[0]);
                return ClientServiceDescriptor.builder(svcDesc);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return ClientServiceDescriptor.builder(serviceClass.getSimpleName(), serviceClass);
    }

    public static Builder builder(String serviceName, Class<?> serviceClass) {
        return new Builder(serviceName, serviceClass);
    }

    public String name() {
        return this.serviceName;
    }

    public ClientMethodDescriptor method(String name) {
        return this.methods.get(name);
    }

    public Collection<ClientMethodDescriptor> methods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public PriorityBag<ClientInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }

    public CallCredentials callCredentials() {
        return this.callCredentials;
    }

    public String toString() {
        return "ClientServiceDescriptor(name='" + this.serviceName + "')";
    }

    public static final class Builder
    implements Rules,
    io.helidon.common.Builder<Builder, ClientServiceDescriptor> {
        private String name;
        private PriorityBag<ClientInterceptor> interceptors = PriorityBag.withDefaultPriority((int)5000);
        private Class<?> serviceClass;
        private Descriptors.FileDescriptor proto;
        private MarshallerSupplier marshallerSupplier = MarshallerSupplier.defaultInstance();
        private CallCredentials callCredentials;
        private Map<String, ClientMethodDescriptor.Builder> methodBuilders = new HashMap<String, ClientMethodDescriptor.Builder>();

        private Builder(BindableService service) {
            this(service.bindService().getServiceDescriptor());
        }

        private Builder(ServiceDescriptor serviceDescriptor) {
            this.name = serviceDescriptor.getName();
            this.serviceClass = serviceDescriptor.getClass();
            for (MethodDescriptor md : serviceDescriptor.getMethods()) {
                String methodName = GrpcHelper.extractMethodName((String)md.getFullMethodName());
                this.methodBuilders.put(methodName, ClientMethodDescriptor.builder(this.name, methodName, md.toBuilder()));
            }
        }

        private Builder(String name, Class serviceClass) {
            this.name = name;
            this.serviceClass = serviceClass;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder name(String serviceName) {
            if (serviceName == null) {
                throw new NullPointerException("Service getName cannot be null");
            }
            if (serviceName.trim().isEmpty()) {
                throw new IllegalArgumentException("Service getName cannot be blank");
            }
            this.name = serviceName.trim();
            for (Map.Entry<String, ClientMethodDescriptor.Builder> e : this.methodBuilders.entrySet()) {
                e.getValue().fullName(MethodDescriptor.generateFullMethodName((String)this.name, (String)e.getKey()));
            }
            return this;
        }

        @Override
        public Builder proto(Descriptors.FileDescriptor proto) {
            this.proto = proto;
            return this;
        }

        @Override
        public Builder marshallerSupplier(MarshallerSupplier marshallerSupplier) {
            this.marshallerSupplier = marshallerSupplier;
            return this;
        }

        @Override
        public Builder unary(String name) {
            return this.unary(name, (Consumer)null);
        }

        @Override
        public Builder unary(String name, Consumer<ClientMethodDescriptor.Rules> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.UNARY, configurer));
            return this;
        }

        @Override
        public Builder serverStreaming(String name) {
            return this.serverStreaming(name, (Consumer)null);
        }

        @Override
        public Builder serverStreaming(String name, Consumer<ClientMethodDescriptor.Rules> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.SERVER_STREAMING, configurer));
            return this;
        }

        @Override
        public Builder clientStreaming(String name) {
            return this.clientStreaming(name, (Consumer)null);
        }

        @Override
        public Builder clientStreaming(String name, Consumer<ClientMethodDescriptor.Rules> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.CLIENT_STREAMING, configurer));
            return this;
        }

        @Override
        public Builder bidirectional(String name) {
            return this.bidirectional(name, (Consumer)null);
        }

        @Override
        public Builder bidirectional(String name, Consumer<ClientMethodDescriptor.Rules> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.BIDI_STREAMING, configurer));
            return this;
        }

        @Override
        public Builder intercept(ClientInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        @Override
        public Rules intercept(int priority, ClientInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), priority);
            return this;
        }

        @Override
        public Builder intercept(String methodName, ClientInterceptor ... interceptors) {
            ClientMethodDescriptor.Builder method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with getName '" + methodName + "'");
            }
            method.intercept(interceptors);
            return this;
        }

        @Override
        public Builder intercept(String methodName, int priority, ClientInterceptor ... interceptors) {
            ClientMethodDescriptor.Builder method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with getName '" + methodName + "'");
            }
            method.intercept(priority, interceptors);
            return this;
        }

        @Override
        public Builder callCredentials(CallCredentials callCredentials) {
            this.callCredentials = callCredentials;
            return this;
        }

        @Override
        public Builder callCredentials(String methodName, CallCredentials callCredentials) {
            ClientMethodDescriptor.Builder method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with getName '" + methodName + "'");
            }
            method.callCredentials(callCredentials);
            return this;
        }

        public ClientServiceDescriptor build() {
            LinkedHashMap<String, ClientMethodDescriptor> methods = new LinkedHashMap<String, ClientMethodDescriptor>();
            for (Map.Entry<String, ClientMethodDescriptor.Builder> entry : this.methodBuilders.entrySet()) {
                methods.put(entry.getKey(), entry.getValue().build());
            }
            return new ClientServiceDescriptor(this.name, methods, this.interceptors, this.callCredentials);
        }

        private ClientMethodDescriptor.Builder createMethodDescriptor(String methodName, MethodDescriptor.MethodType methodType, Consumer<ClientMethodDescriptor.Rules> configurer) {
            MethodDescriptor.Builder grpcDesc = MethodDescriptor.newBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)this.name, (String)methodName)).setType(methodType).setSampledToLocalTracing(true);
            Class<?> requestType = this.getTypeFromMethodDescriptor(methodName, true);
            Class<?> responseType = this.getTypeFromMethodDescriptor(methodName, false);
            ClientMethodDescriptor.Builder builder = ClientMethodDescriptor.builder(this.name, methodName, grpcDesc).defaultMarshallerSupplier(this.marshallerSupplier).requestType(requestType).responseType(responseType);
            if (configurer != null) {
                configurer.accept(builder);
            }
            return builder;
        }

        private Class<?> getTypeFromMethodDescriptor(String methodName, boolean fInput) {
            if (this.proto == null) {
                return Object.class;
            }
            Descriptors.ServiceDescriptor svc = this.proto.findServiceByName(this.name);
            Descriptors.MethodDescriptor mtd = svc.findMethodByName(methodName);
            Descriptors.Descriptor type = fInput ? mtd.getInputType() : mtd.getOutputType();
            String pkg = this.getPackageName();
            String outerClass = this.getOuterClassName();
            String className = pkg + "." + outerClass + type.getFullName().replace('.', '$');
            try {
                return this.serviceClass != null ? this.serviceClass.getClassLoader().loadClass(className) : this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private String getPackageName() {
            String pkg = this.proto.getOptions().getJavaPackage();
            return "".equals(pkg) ? this.proto.getPackage() : pkg;
        }

        private String getOuterClassName() {
            DescriptorProtos.FileOptions options = this.proto.getOptions();
            if (options.getJavaMultipleFiles()) {
                return "";
            }
            String outerClass = options.getJavaOuterClassname();
            if ("".equals(outerClass)) {
                outerClass = this.getOuterClassFromFileName(this.proto.getName());
            }
            return outerClass + "$";
        }

        private String getOuterClassFromFileName(String name) {
            name = name.substring(0, name.lastIndexOf(".proto"));
            String[] words = name.split("_");
            StringBuilder sb = new StringBuilder(name.length());
            for (String word : words) {
                sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
            }
            return sb.toString();
        }
    }

    public static interface Rules {
        public String name();

        public Rules name(String var1);

        public Rules proto(Descriptors.FileDescriptor var1);

        public Rules marshallerSupplier(MarshallerSupplier var1);

        public Rules intercept(ClientInterceptor ... var1);

        public Rules intercept(int var1, ClientInterceptor ... var2);

        public Rules intercept(String var1, ClientInterceptor ... var2);

        public Rules intercept(String var1, int var2, ClientInterceptor ... var3);

        public Rules unary(String var1);

        public Rules unary(String var1, Consumer<ClientMethodDescriptor.Rules> var2);

        public Rules serverStreaming(String var1);

        public Rules serverStreaming(String var1, Consumer<ClientMethodDescriptor.Rules> var2);

        public Rules clientStreaming(String var1);

        public Rules clientStreaming(String var1, Consumer<ClientMethodDescriptor.Rules> var2);

        public Rules bidirectional(String var1);

        public Rules bidirectional(String var1, Consumer<ClientMethodDescriptor.Rules> var2);

        public Rules callCredentials(CallCredentials var1);

        public Rules callCredentials(String var1, CallCredentials var2);
    }
}

