/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.client;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.helidon.common.configurable.Resource;
import io.helidon.config.Config;
import io.helidon.grpc.client.GrpcChannelDescriptor;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;

public class GrpcChannelsProvider {
    public static final String DEFAULT_CHANNEL_NAME = "default";
    public static final String DEFAULT_HOST = "localhost";
    public static final String CFG_KEY_CHANNELS = "channels";
    public static final int DEFAULT_PORT = 1408;
    private Map<String, GrpcChannelDescriptor> channelConfigs;

    private GrpcChannelsProvider(Map<String, GrpcChannelDescriptor> channelDescriptors) {
        this.channelConfigs = new HashMap<String, GrpcChannelDescriptor>(channelDescriptors);
    }

    public static GrpcChannelsProvider create() {
        return GrpcChannelsProvider.builder().build();
    }

    public static GrpcChannelsProvider create(Config config) {
        return new Builder(config).build();
    }

    public static Builder builder() {
        return GrpcChannelsProvider.builder(null);
    }

    public static Builder builder(Config config) {
        return new Builder(config);
    }

    private static SslContext createClientSslContext(Resource trustCert, Resource clientCert, Resource clientPrivateKey) {
        try {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (trustCert != null) {
                builder.trustManager(trustCert.stream());
            }
            if (clientCert != null && clientPrivateKey != null) {
                builder.keyManager(clientCert.stream(), clientPrivateKey.stream());
            }
            return builder.build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Error creating SSL context", e);
        }
    }

    public ManagedChannel channel(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be empty or blank.");
        }
        GrpcChannelDescriptor chCfg = this.channelConfigs.computeIfAbsent(name, hostName -> GrpcChannelDescriptor.builder().host(name).build());
        return this.createChannel(chCfg);
    }

    Map<String, GrpcChannelDescriptor> channels() {
        return this.channelConfigs;
    }

    private ManagedChannel createChannel(GrpcChannelDescriptor descriptor) {
        ManagedChannelBuilder builder = descriptor.tlsDescriptor().map(tlsDescriptor -> this.createNettyChannelBuilder(descriptor, (GrpcTlsDescriptor)tlsDescriptor)).orElse(this.createManagedChannelBuilder(descriptor));
        descriptor.loadBalancerPolicy().ifPresent(arg_0 -> ((ManagedChannelBuilder)builder).defaultLoadBalancingPolicy(arg_0));
        descriptor.nameResolverFactory().ifPresent(arg_0 -> ((ManagedChannelBuilder)builder).nameResolverFactory(arg_0));
        return builder.build();
    }

    private ManagedChannelBuilder createNettyChannelBuilder(GrpcChannelDescriptor descriptor, GrpcTlsDescriptor tlsDescriptor) {
        return descriptor.target().map(NettyChannelBuilder::forTarget).orElse(NettyChannelBuilder.forAddress((String)descriptor.host(), (int)descriptor.port())).negotiationType(NegotiationType.TLS).sslContext(GrpcChannelsProvider.createClientSslContext(tlsDescriptor.tlsCaCert(), tlsDescriptor.tlsCert(), tlsDescriptor.tlsKey()));
    }

    private ManagedChannelBuilder createManagedChannelBuilder(GrpcChannelDescriptor descriptor) {
        return descriptor.target().map(ManagedChannelBuilder::forTarget).orElse(ManagedChannelBuilder.forAddress((String)descriptor.host(), (int)descriptor.port())).usePlaintext();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GrpcChannelsProvider> {
        private Map<String, GrpcChannelDescriptor> channelConfigs = new HashMap<String, GrpcChannelDescriptor>();

        private Builder(Config config) {
            this.channel(GrpcChannelsProvider.DEFAULT_CHANNEL_NAME, GrpcChannelDescriptor.builder().build());
            if (config == null) {
                return;
            }
            Config channelsConfig = config.get(GrpcChannelsProvider.CFG_KEY_CHANNELS);
            if (channelsConfig.exists()) {
                for (Config channelConfig : (List)channelsConfig.asNodeList().get()) {
                    String key = channelConfig.key().name();
                    GrpcChannelDescriptor cfg = (GrpcChannelDescriptor)((Config)channelConfig.asNode().get()).as(GrpcChannelDescriptor.class).get();
                    this.channelConfigs.put(key, cfg);
                }
            }
        }

        public Builder channel(String name, GrpcChannelDescriptor descriptor) {
            this.channelConfigs.put(name, descriptor);
            return this;
        }

        public GrpcChannelsProvider build() {
            return new GrpcChannelsProvider(this.channelConfigs);
        }
    }
}

