/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.client;

import io.grpc.NameResolver;
import io.helidon.config.metadata.Configured;
import io.helidon.config.objectmapping.Value;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import java.util.Optional;

public class GrpcChannelDescriptor {
    private boolean inProcessChannel;
    private String host;
    private int port;
    private String target;
    private GrpcTlsDescriptor tlsDescriptor;
    private String loadBalancerPolicy;
    private NameResolver.Factory nameResolver;

    private GrpcChannelDescriptor(Builder builder) {
        this.inProcessChannel = builder.inProcessChannel();
        this.target = builder.target();
        this.host = builder.host();
        this.port = builder.port();
        this.tlsDescriptor = builder.tlsDescriptor();
        this.loadBalancerPolicy = builder.loadBalancerPolicy();
        this.nameResolver = builder.nameResolverFactory();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isInProcessChannel() {
        return this.inProcessChannel;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Optional<String> target() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> loadBalancerPolicy() {
        return Optional.ofNullable(this.loadBalancerPolicy);
    }

    @Deprecated
    public Optional<NameResolver.Factory> nameResolverFactory() {
        return Optional.ofNullable(this.nameResolver);
    }

    public Optional<GrpcTlsDescriptor> tlsDescriptor() {
        if (this.tlsDescriptor != null && this.tlsDescriptor.isEnabled()) {
            return Optional.of(this.tlsDescriptor);
        }
        return Optional.empty();
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<Builder, GrpcChannelDescriptor> {
        private boolean inProcessChannel;
        private String host = "localhost";
        private int port = 1408;
        private GrpcTlsDescriptor tlsDescriptor;
        private String target;
        private String loadBalancerPolicy;
        private NameResolver.Factory nameResolver;

        @Value(key="inProcess", withDefault="localhost")
        public Builder inProcess() {
            this.inProcessChannel = true;
            return this;
        }

        @Value
        public Builder target(String target) {
            this.target = target;
            return this;
        }

        @Value(withDefault="localhost")
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Value(withDefault="1408")
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Value(key="tls")
        public Builder sslDescriptor(GrpcTlsDescriptor tlsDescriptor) {
            this.tlsDescriptor = tlsDescriptor;
            return this;
        }

        public Builder loadBalancerPolicy(String policy) {
            this.loadBalancerPolicy = policy;
            return this;
        }

        @Deprecated
        public Builder nameResolverFactory(NameResolver.Factory factory) {
            this.nameResolver = factory;
            return this;
        }

        boolean inProcessChannel() {
            return this.inProcessChannel;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }

        GrpcTlsDescriptor tlsDescriptor() {
            return this.tlsDescriptor;
        }

        String target() {
            return this.target;
        }

        String loadBalancerPolicy() {
            return this.loadBalancerPolicy;
        }

        NameResolver.Factory nameResolverFactory() {
            return this.nameResolver;
        }

        public GrpcChannelDescriptor build() {
            return new GrpcChannelDescriptor(this);
        }
    }
}

