/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import io.helidon.grpc.client.ClientMethodDescriptor;
import io.helidon.grpc.client.ClientProxy;
import io.helidon.grpc.client.ClientServiceDescriptor;
import io.helidon.grpc.core.MethodHandler;
import io.helidon.grpc.core.PriorityBag;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class GrpcServiceClient {
    private final HashMap<String, GrpcMethodStub> methodStubs;
    private final ClientServiceDescriptor clientServiceDescriptor;

    public static Builder builder(Channel channel, ClientServiceDescriptor descriptor) {
        return new Builder(channel, descriptor);
    }

    public static GrpcServiceClient create(Channel channel, ClientServiceDescriptor descriptor) {
        return GrpcServiceClient.builder(channel, descriptor).build();
    }

    private GrpcServiceClient(Channel channel, CallOptions callOptions, ClientServiceDescriptor clientServiceDescriptor) {
        this.clientServiceDescriptor = clientServiceDescriptor;
        this.methodStubs = new HashMap();
        for (ClientMethodDescriptor methodDescriptor : clientServiceDescriptor.methods()) {
            GrpcMethodStub methodStub = new GrpcMethodStub(channel, callOptions, methodDescriptor);
            PriorityBag priorityInterceptors = PriorityBag.withDefaultPriority((int)5000);
            priorityInterceptors.addAll(clientServiceDescriptor.interceptors());
            priorityInterceptors.addAll(methodDescriptor.interceptors());
            List interceptors = priorityInterceptors.stream().collect(Collectors.toList());
            if (interceptors.size() > 0) {
                LinkedHashSet<ClientInterceptor> uniqueInterceptors = new LinkedHashSet<ClientInterceptor>(interceptors.size());
                for (int i = interceptors.size() - 1; i >= 0; --i) {
                    ClientInterceptor interceptor = (ClientInterceptor)interceptors.get(i);
                    if (uniqueInterceptors.contains(interceptor)) continue;
                    uniqueInterceptors.add(interceptor);
                }
                for (ClientInterceptor interceptor : uniqueInterceptors) {
                    methodStub = (GrpcMethodStub)methodStub.withInterceptors(new ClientInterceptor[]{interceptor});
                }
            }
            if (methodDescriptor.callCredentials() != null) {
                methodStub = (GrpcMethodStub)methodStub.withCallCredentials(methodDescriptor.callCredentials());
            } else if (clientServiceDescriptor.callCredentials() != null) {
                methodStub = (GrpcMethodStub)methodStub.withCallCredentials(clientServiceDescriptor.callCredentials());
            }
            this.methodStubs.put(methodDescriptor.name(), methodStub);
        }
    }

    public String serviceName() {
        return this.clientServiceDescriptor.name();
    }

    Object invoke(String name, Object[] args) {
        GrpcMethodStub stub = this.methodStubs.get(name);
        if (stub == null) {
            throw Status.INTERNAL.withDescription("gRPC method '" + name + "' does not exist").asRuntimeException();
        }
        ClientMethodDescriptor descriptor = stub.descriptor();
        MethodHandler methodHandler = descriptor.methodHandler();
        switch (descriptor.descriptor().getType()) {
            case UNARY: {
                return methodHandler.unary(args, this::unary);
            }
            case CLIENT_STREAMING: {
                return methodHandler.clientStreaming(args, this::clientStreaming);
            }
            case SERVER_STREAMING: {
                return methodHandler.serverStreaming(args, this::serverStreaming);
            }
            case BIDI_STREAMING: {
                return methodHandler.bidirectional(args, this::bidiStreaming);
            }
        }
        throw Status.INTERNAL.withDescription("Unknown or unsupported method type for method " + name).asRuntimeException();
    }

    public <T> T proxy(Class<T> type, Class<?> ... extraTypes) {
        Class[] proxyTypes;
        HashMap<String, String> names = new HashMap<String, String>();
        for (ClientMethodDescriptor methodDescriptor : this.clientServiceDescriptor.methods()) {
            MethodHandler methodHandler = methodDescriptor.methodHandler();
            if (methodHandler == null) continue;
            names.put(methodHandler.javaMethodName(), methodDescriptor.name());
        }
        if (extraTypes == null || extraTypes.length == 0) {
            proxyTypes = new Class[]{type};
        } else {
            proxyTypes = new Class[extraTypes.length + 1];
            proxyTypes[0] = type;
            System.arraycopy(extraTypes, 0, proxyTypes, 1, extraTypes.length);
        }
        return (T)Proxy.newProxyInstance(type.getClassLoader(), proxyTypes, (InvocationHandler)ClientProxy.create(this, names));
    }

    public <ReqT, RespT> RespT blockingUnary(String methodName, ReqT request) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.UNARY);
        return (RespT)ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), stub.descriptor().descriptor(), (CallOptions)stub.getCallOptions(), request);
    }

    public <ReqT, RespT> CompletionStage<RespT> unary(String methodName, ReqT request) {
        SingleValueStreamObserver observer = new SingleValueStreamObserver();
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.UNARY);
        ClientCalls.asyncUnaryCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), request, observer);
        return observer.completionStage();
    }

    public <ReqT, RespT> void unary(String methodName, ReqT request, StreamObserver<RespT> observer) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.UNARY);
        ClientCalls.asyncUnaryCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), request, observer);
    }

    public <ReqT, RespT> Iterator<RespT> blockingServerStreaming(String methodName, ReqT request) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.SERVER_STREAMING);
        return ClientCalls.blockingServerStreamingCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), request);
    }

    public <ReqT, RespT> void serverStreaming(String methodName, ReqT request, StreamObserver<RespT> observer) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.SERVER_STREAMING);
        ClientCalls.asyncServerStreamingCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), request, observer);
    }

    public <ReqT, RespT> CompletionStage<RespT> clientStreaming(String methodName, Iterable<ReqT> items) {
        return this.clientStreaming(methodName, StreamSupport.stream(items.spliterator(), false));
    }

    public <ReqT, RespT> CompletionStage<RespT> clientStreaming(String methodName, Stream<ReqT> items) {
        SingleValueStreamObserver obsv = new SingleValueStreamObserver();
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.CLIENT_STREAMING);
        StreamObserver reqStream = ClientCalls.asyncClientStreamingCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), obsv);
        items.forEach(item -> reqStream.onNext(item));
        reqStream.onCompleted();
        return obsv.completionStage();
    }

    public <ReqT, RespT> StreamObserver<ReqT> clientStreaming(String methodName, StreamObserver<RespT> observer) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.CLIENT_STREAMING);
        return ClientCalls.asyncClientStreamingCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), observer);
    }

    public <ReqT, RespT> StreamObserver<ReqT> bidiStreaming(String methodName, StreamObserver<RespT> observer) {
        GrpcMethodStub<ReqT, RespT> stub = this.ensureMethod(methodName, MethodDescriptor.MethodType.BIDI_STREAMING);
        return ClientCalls.asyncBidiStreamingCall((ClientCall)stub.getChannel().newCall(stub.descriptor().descriptor(), stub.getCallOptions()), observer);
    }

    private <ReqT, RespT> GrpcMethodStub<ReqT, RespT> ensureMethod(String methodName, MethodDescriptor.MethodType methodType) {
        GrpcMethodStub stub = this.methodStubs.get(methodName);
        if (stub == null) {
            throw new IllegalArgumentException("No method named " + methodName + " registered with this service");
        }
        ClientMethodDescriptor cmd = stub.descriptor();
        if (cmd.descriptor().getType() != methodType) {
            throw new IllegalArgumentException("Method (" + methodName + ") already registered with a different method type.");
        }
        return stub;
    }

    public static class Builder {
        private Channel channel;
        private CallOptions callOptions = CallOptions.DEFAULT;
        private ClientServiceDescriptor clientServiceDescriptor;

        private Builder(Channel channel, ClientServiceDescriptor descriptor) {
            this.channel = channel;
            this.clientServiceDescriptor = descriptor;
        }

        public Builder callOptions(CallOptions callOptions) {
            this.callOptions = callOptions;
            return this;
        }

        public GrpcServiceClient build() {
            return new GrpcServiceClient(this.channel, this.callOptions, this.clientServiceDescriptor);
        }
    }

    private static class GrpcMethodStub<ReqT, RespT>
    extends AbstractStub<GrpcMethodStub<ReqT, RespT>> {
        private ClientMethodDescriptor cmd;

        GrpcMethodStub(Channel channel, CallOptions callOptions, ClientMethodDescriptor cmd) {
            super(channel, callOptions);
            this.cmd = cmd;
        }

        protected GrpcMethodStub<ReqT, RespT> build(Channel channel, CallOptions callOptions) {
            return new GrpcMethodStub<ReqT, RespT>(channel, callOptions, this.cmd);
        }

        public ClientMethodDescriptor descriptor() {
            return this.cmd;
        }
    }

    public static class SingleValueStreamObserver<T>
    implements StreamObserver<T> {
        private int count;
        private T result;
        private CompletableFuture<T> resultFuture = new CompletableFuture();

        public CompletionStage<T> completionStage() {
            return this.resultFuture;
        }

        public void onNext(T value) {
            if (this.count++ == 0) {
                this.result = value;
            } else {
                this.resultFuture.completeExceptionally(new IllegalStateException("More than one result received."));
            }
        }

        public void onError(Throwable t) {
            this.resultFuture.completeExceptionally(t);
        }

        public void onCompleted() {
            this.resultFuture.complete(this.result);
        }
    }
}

