/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.metrics;

import io.grpc.Context;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.helidon.common.LazyValue;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.grpc.server.MethodDescriptor;
import io.helidon.grpc.server.ServiceDescriptor;
import io.helidon.metrics.api.RegistryFactory;
import jakarta.annotation.Priority;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Priority(value=1002)
public class GrpcMetrics
implements ServerInterceptor,
ServiceDescriptor.Configurer,
MethodDescriptor.Configurer {
    static final LazyValue<MetricRegistry> VENDOR_REGISTRY = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.VENDOR));
    static final LazyValue<MetricRegistry> APP_REGISTRY = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.APPLICATION));
    static final org.eclipse.microprofile.metrics.Metadata GRPC_METER = org.eclipse.microprofile.metrics.Metadata.builder().withName("grpc.requests.meter").withDisplayName("Meter for overall gRPC requests").withDescription("Each gRPC request will mark the meter to see overall throughput").withType(MetricType.METERED).withUnit("none").build();
    private static final String KEY_STRING = GrpcMetrics.class.getName();
    private static final Context.Key<MetricsRules> KEY = Context.keyWithDefault((String)KEY_STRING, (Object)new MetricsRules(MetricType.INVALID));
    private final MetricsRules metricRule;

    private GrpcMetrics(MetricsRules rules) {
        this.metricRule = rules;
    }

    public void configure(MethodDescriptor.Rules rules) {
        rules.addContextValue(KEY, (Object)this.metricRule);
    }

    public void configure(ServiceDescriptor.Rules rules) {
        rules.addContextValue(KEY, (Object)this.metricRule);
    }

    public GrpcMetrics tags(Map<String, String> tags) {
        return new GrpcMetrics(this.metricRule.tags(tags));
    }

    public GrpcMetrics description(String description) {
        return new GrpcMetrics(this.metricRule.description(description));
    }

    public GrpcMetrics displayName(String displayName) {
        return new GrpcMetrics(this.metricRule.displayName(displayName));
    }

    public GrpcMetrics units(String units) {
        return new GrpcMetrics(this.metricRule.units(units));
    }

    public MetricType metricType() {
        return this.metricRule.type();
    }

    public GrpcMetrics nameFunction(NamingFunction function) {
        return new GrpcMetrics(this.metricRule.nameFunction(function));
    }

    public static GrpcMetrics counted() {
        return new GrpcMetrics(new MetricsRules(MetricType.COUNTER));
    }

    public static GrpcMetrics metered() {
        return new GrpcMetrics(new MetricsRules(MetricType.METERED));
    }

    public static GrpcMetrics histogram() {
        return new GrpcMetrics(new MetricsRules(MetricType.HISTOGRAM));
    }

    public static GrpcMetrics timed() {
        return new GrpcMetrics(new MetricsRules(MetricType.TIMER));
    }

    public static GrpcMetrics concurrentGauge() {
        return new GrpcMetrics(new MetricsRules(MetricType.CONCURRENT_GAUGE));
    }

    public static GrpcMetrics simplyTimed() {
        return new GrpcMetrics(new MetricsRules(MetricType.SIMPLE_TIMER));
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MetricsRules rules = (MetricsRules)Context.keyWithDefault((String)KEY_STRING, (Object)this.metricRule).get();
        MetricType type = rules.type();
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        String methodName = GrpcHelper.extractMethodName((String)fullMethodName);
        ServiceDescriptor service = (ServiceDescriptor)ServiceDescriptor.SERVICE_DESCRIPTOR_KEY.get();
        Object serverCall = switch (type) {
            case MetricType.COUNTER -> new CountedServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).counter(rules.metadata(service, methodName), rules.toTags()), call);
            case MetricType.METERED -> new MeteredServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).meter(rules.metadata(service, methodName), rules.toTags()), call);
            case MetricType.HISTOGRAM -> new HistogramServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).histogram(rules.metadata(service, methodName), rules.toTags()), call);
            case MetricType.TIMER -> new TimedServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).timer(rules.metadata(service, methodName), rules.toTags()), call);
            case MetricType.SIMPLE_TIMER -> new SimplyTimedServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).simpleTimer(rules.metadata(service, methodName), rules.toTags()), call);
            case MetricType.CONCURRENT_GAUGE -> new ConcurrentGaugeServerCall<ReqT, RespT>(((MetricRegistry)APP_REGISTRY.get()).concurrentGauge(rules.metadata(service, methodName), rules.toTags()), call);
            default -> call;
        };
        serverCall = new MeteredServerCall<ReqT, RespT>(((MetricRegistry)VENDOR_REGISTRY.get()).meter(GRPC_METER), serverCall);
        return next.startCall(serverCall, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static class MetricsRules {
        private static final Tag[] EMPTY_TAGS = new Tag[0];
        private MetricType type;
        private Optional<HashMap<String, String>> tags = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<String> units = Optional.empty();
        private Optional<NamingFunction> nameFunction = Optional.empty();

        private MetricsRules(MetricType type) {
            this.type = type;
        }

        private MetricsRules(MetricsRules copy) {
            this.type = copy.type;
            this.tags = copy.tags;
            this.description = copy.description;
            this.displayName = copy.displayName;
            this.units = copy.units;
            this.nameFunction = copy.nameFunction;
        }

        MetricType type() {
            return this.type;
        }

        org.eclipse.microprofile.metrics.Metadata metadata(ServiceDescriptor service, String method) {
            String name = this.nameFunction.orElse(this::defaultName).createName(service, method, this.type);
            MetadataBuilder builder = org.eclipse.microprofile.metrics.Metadata.builder().withName(name).withType(this.type);
            this.description.ifPresent(arg_0 -> ((MetadataBuilder)builder).withDescription(arg_0));
            this.units.ifPresent(arg_0 -> ((MetadataBuilder)builder).withUnit(arg_0));
            this.displayName.ifPresent(arg_0 -> ((MetadataBuilder)builder).withDisplayName(arg_0));
            return builder.build();
        }

        private String defaultName(ServiceDescriptor service, String methodName, MetricType metricType) {
            return (service.name() + "." + methodName).replaceAll("/", ".");
        }

        private MetricsRules tags(Map<String, String> tags) {
            MetricsRules rules = new MetricsRules(this);
            rules.tags = Optional.of(new HashMap<String, String>(tags));
            return rules;
        }

        private MetricsRules description(String description) {
            MetricsRules rules = new MetricsRules(this);
            rules.description = Optional.of(description);
            return rules;
        }

        private MetricsRules displayName(String displayName) {
            MetricsRules rules = new MetricsRules(this);
            rules.displayName = Optional.of(displayName);
            return rules;
        }

        private MetricsRules nameFunction(NamingFunction function) {
            MetricsRules rules = new MetricsRules(this);
            rules.nameFunction = Optional.of(function);
            return rules;
        }

        private MetricsRules units(String units) {
            MetricsRules rules = new MetricsRules(this);
            rules.units = Optional.of(units);
            return rules;
        }

        private Tag[] toTags() {
            return this.tags.isPresent() ? (Tag[])this.tags.get().entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).toArray(Tag[]::new) : EMPTY_TAGS;
        }
    }

    @FunctionalInterface
    public static interface NamingFunction {
        public String createName(ServiceDescriptor var1, String var2, MetricType var3);
    }

    private class CountedServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, Counter> {
        private CountedServerCall(Counter counter, ServerCall<ReqT, RespT> delegate) {
            super(counter, delegate);
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            ((Counter)this.getMetric()).inc();
        }
    }

    private class MeteredServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, Meter> {
        private MeteredServerCall(Meter meter, ServerCall<ReqT, RespT> delegate) {
            super(meter, delegate);
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            ((Meter)this.getMetric()).mark();
        }
    }

    private class HistogramServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, Histogram> {
        private HistogramServerCall(Histogram histogram, ServerCall<ReqT, RespT> delegate) {
            super(histogram, delegate);
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            ((Histogram)this.getMetric()).update(1);
        }
    }

    private class TimedServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, Timer> {
        private final long startNanos;

        private TimedServerCall(Timer timer, ServerCall<ReqT, RespT> delegate) {
            super(timer, delegate);
            this.startNanos = System.nanoTime();
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            long time = System.nanoTime() - this.startNanos;
            ((Timer)this.getMetric()).update(Duration.ofNanos(time));
        }
    }

    private class SimplyTimedServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, SimpleTimer> {
        private final long startNanos;

        private SimplyTimedServerCall(SimpleTimer simpleTimer, ServerCall<ReqT, RespT> delegate) {
            super(simpleTimer, delegate);
            this.startNanos = System.nanoTime();
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            long time = System.nanoTime() - this.startNanos;
            ((SimpleTimer)this.getMetric()).update(Duration.ofNanos(time));
        }
    }

    private class ConcurrentGaugeServerCall<ReqT, RespT>
    extends MetricServerCall<ReqT, RespT, ConcurrentGauge> {
        private ConcurrentGaugeServerCall(ConcurrentGauge concurrentGauge, ServerCall<ReqT, RespT> delegate) {
            super(concurrentGauge, delegate);
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            ((ConcurrentGauge)this.getMetric()).inc();
        }
    }

    private abstract class MetricServerCall<ReqT, RespT, MetricT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private final MetricT metric;

        private MetricServerCall(MetricT metric, ServerCall<ReqT, RespT> delegate) {
            super(delegate);
            this.metric = metric;
        }

        protected MetricT getMetric() {
            return this.metric;
        }
    }
}

