/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.StreamObserver;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.MethodDescriptor;
import io.helidon.grpc.server.ServiceDescriptor;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class BindableServiceImpl
implements BindableService {
    private final ServiceDescriptor descriptor;
    private final PriorityBag<ServerInterceptor> globalInterceptors;

    private BindableServiceImpl(ServiceDescriptor descriptor, PriorityBag<ServerInterceptor> interceptors) {
        this.descriptor = descriptor;
        this.globalInterceptors = interceptors.copyMe();
    }

    static BindableServiceImpl create(ServiceDescriptor descriptor, PriorityBag<ServerInterceptor> interceptors) {
        return new BindableServiceImpl(descriptor, interceptors);
    }

    public ServerServiceDefinition bindService() {
        ServiceDescriptor.Builder serviceDescriptorBuilder = io.grpc.ServiceDescriptor.newBuilder((String)this.descriptor.fullName());
        if (this.descriptor.proto() != null) {
            serviceDescriptorBuilder.setSchemaDescriptor(this.descriptor::proto);
        }
        this.descriptor.methods().forEach(method -> serviceDescriptorBuilder.addMethod(method.descriptor()));
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((io.grpc.ServiceDescriptor)serviceDescriptorBuilder.build());
        this.descriptor.methods().forEach(method -> builder.addMethod(method.descriptor(), this.wrapCallHandler((MethodDescriptor)method)));
        return builder.build();
    }

    private <ReqT, RespT> ServerCallHandler<ReqT, RespT> wrapCallHandler(MethodDescriptor<ReqT, RespT> method) {
        ServerCallHandler<ReqT, RespT> handler = method.callHandler();
        PriorityBag priorityServerInterceptors = PriorityBag.withDefaultPriority((int)5000);
        priorityServerInterceptors.addAll(this.globalInterceptors);
        priorityServerInterceptors.addAll(this.descriptor.interceptors());
        priorityServerInterceptors.addAll(method.interceptors());
        List interceptors = priorityServerInterceptors.stream().collect(Collectors.toList());
        if (!interceptors.isEmpty()) {
            LinkedHashSet<ServerInterceptor> uniqueInterceptors = new LinkedHashSet<ServerInterceptor>(interceptors.size());
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                ServerInterceptor interceptor = (ServerInterceptor)interceptors.get(i);
                if (uniqueInterceptors.contains(interceptor)) continue;
                uniqueInterceptors.add(interceptor);
            }
            for (ServerInterceptor interceptor : uniqueInterceptors) {
                handler = new InterceptingCallHandler<ReqT, RespT>(this.descriptor, interceptor, handler);
            }
        }
        return handler;
    }

    static <T> Supplier<T> createSupplier(Callable<T> callable) {
        return new CallableSupplier<T>(callable);
    }

    static <T, U> BiConsumer<T, Throwable> completeWithResult(StreamObserver<U> observer) {
        return new CompletionAction(observer, true);
    }

    static <U> BiConsumer<Void, Throwable> completeWithoutResult(StreamObserver<U> observer) {
        return new CompletionAction(observer, false);
    }

    static final class InterceptingCallHandler<ReqT, RespT>
    implements ServerCallHandler<ReqT, RespT> {
        private final ServiceDescriptor serviceDefinition;
        private final ServerInterceptor interceptor;
        private final ServerCallHandler<ReqT, RespT> callHandler;

        private InterceptingCallHandler(ServiceDescriptor serviceDefinition, ServerInterceptor interceptor, ServerCallHandler<ReqT, RespT> callHandler) {
            this.serviceDefinition = serviceDefinition;
            this.interceptor = interceptor;
            this.callHandler = callHandler;
        }

        public ServerCall.Listener<ReqT> startCall(ServerCall<ReqT, RespT> call, Metadata headers) {
            if (this.interceptor instanceof ServiceDescriptor.Aware) {
                ((ServiceDescriptor.Aware)this.interceptor).setServiceDescriptor(this.serviceDefinition);
            }
            return this.interceptor.interceptCall(call, headers, this.callHandler);
        }
    }

    static class CallableSupplier<T>
    implements Supplier<T> {
        private Callable<T> callable;

        CallableSupplier(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T get() {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        }
    }

    static class CompletionAction<T, U>
    implements BiConsumer<T, Throwable> {
        private StreamObserver<U> observer;
        private boolean sendResult;

        CompletionAction(StreamObserver<U> observer, boolean sendResult) {
            this.observer = observer;
            this.sendResult = sendResult;
        }

        @Override
        public void accept(T result, Throwable error) {
            if (error != null) {
                this.observer.onError(error);
            } else {
                if (this.sendResult) {
                    this.observer.onNext(result);
                }
                this.observer.onCompleted();
            }
        }
    }
}

