/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

public class CollectingObserver<T, V, U, A, R>
implements StreamObserver<V> {
    private final Collector<T, A, R> collector;
    private final StreamObserver<U> responseObserver;
    private final Function<V, T> requestConverter;
    private final Function<R, U> responseConverter;
    private final Consumer<Throwable> errorHandler;
    private final A accumulator;

    public CollectingObserver(Collector<T, A, R> collector, StreamObserver<U> responseObserver) {
        this(collector, responseObserver, null, null, null);
    }

    public CollectingObserver(Collector<T, A, R> collector, StreamObserver<U> responseObserver, Consumer<Throwable> errorHandler) {
        this(collector, responseObserver, null, null, errorHandler);
    }

    public CollectingObserver(Collector<T, A, R> collector, StreamObserver<U> responseObserver, Function<V, T> requestConverter, Function<R, U> responseConverter) {
        this(collector, responseObserver, requestConverter, responseConverter, null);
    }

    public CollectingObserver(Collector<T, A, R> collector, StreamObserver<U> observer, Function<V, T> requestConverter, Function<R, U> responseConverter, Consumer<Throwable> errorHandler) {
        this.collector = Objects.requireNonNull(collector, "The collector parameter cannot be null");
        this.responseObserver = Objects.requireNonNull(observer, "The observer parameter cannot be null");
        this.requestConverter = Optional.ofNullable(requestConverter).orElse(v -> v);
        this.responseConverter = Optional.ofNullable(responseConverter).orElse(r -> r);
        this.errorHandler = Optional.ofNullable(errorHandler).orElse(t -> {});
        this.accumulator = collector.supplier().get();
    }

    public void onNext(V value) {
        this.collector.accumulator().accept(this.accumulator, this.requestConverter.apply(value));
    }

    public void onError(Throwable t) {
        this.errorHandler.accept(t);
    }

    public void onCompleted() {
        R result = this.collector.finisher().apply(this.accumulator);
        this.responseObserver.onNext(this.responseConverter.apply(result));
        this.responseObserver.onCompleted();
    }
}

