/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.grpc.server.MethodDescriptor;
import io.helidon.grpc.server.ServiceDescriptor;
import jakarta.annotation.Priority;
import java.util.HashMap;
import java.util.Map;

@Priority(value=1000)
class ContextSettingServerInterceptor
implements ServerInterceptor,
ServiceDescriptor.Aware {
    private ServiceDescriptor serviceDescriptor;

    private ContextSettingServerInterceptor() {
    }

    static ContextSettingServerInterceptor create() {
        return new ContextSettingServerInterceptor();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context context = Context.current();
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        String methodName = GrpcHelper.extractMethodName((String)fullMethodName);
        MethodDescriptor methodDescriptor = this.serviceDescriptor.method(methodName);
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>();
        contextMap.putAll(this.serviceDescriptor.context());
        contextMap.putAll(methodDescriptor.context());
        contextMap.put(ServiceDescriptor.SERVICE_DESCRIPTOR_KEY, this.serviceDescriptor);
        if (!contextMap.isEmpty()) {
            for (Map.Entry entry : contextMap.entrySet()) {
                Context.Key key = (Context.Key)entry.getKey();
                context = context.withValue(key, entry.getValue());
            }
        }
        return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
    }

    @Override
    public void setServiceDescriptor(ServiceDescriptor descriptor) {
        this.serviceDescriptor = descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

