/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.GrpcRoutingImpl;
import io.helidon.grpc.server.GrpcServer;
import io.helidon.grpc.server.GrpcServerConfiguration;
import io.helidon.grpc.server.GrpcService;
import io.helidon.grpc.server.ServiceDescriptor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface GrpcRouting {
    public List<ServiceDescriptor> services();

    public PriorityBag<ServerInterceptor> interceptors();

    public static Builder builder() {
        return new Builder();
    }

    default public GrpcServer createServer(GrpcServerConfiguration configuration) {
        return GrpcServer.create(configuration, this);
    }

    default public GrpcServer createServer() {
        return GrpcServer.create(this);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, GrpcRouting> {
        private Map<String, ServiceDescriptor> services = new LinkedHashMap<String, ServiceDescriptor>();
        private PriorityBag<ServerInterceptor> interceptors = PriorityBag.withDefaultPriority((int)5000);

        public Builder intercept(ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        public Builder intercept(int priority, ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), priority);
            return this;
        }

        public Builder register(GrpcService service) {
            return this.register(service, null);
        }

        public Builder register(GrpcService service, ServiceDescriptor.Configurer configurer) {
            return this.register(ServiceDescriptor.builder(service), configurer);
        }

        public Builder register(BindableService service) {
            return this.register(service, null);
        }

        public Builder register(BindableService service, ServiceDescriptor.Configurer configurer) {
            return this.register(ServiceDescriptor.builder(service), configurer);
        }

        public Builder register(ServiceDescriptor service) {
            String name = service.name();
            if (this.services.containsKey(name)) {
                throw new IllegalArgumentException("Attempted to register service name " + name + " multiple times");
            }
            this.services.put(name, service);
            return this;
        }

        public GrpcRouting build() {
            return GrpcRoutingImpl.create(this.services.values(), this.interceptors);
        }

        private Builder register(ServiceDescriptor.Builder builder, ServiceDescriptor.Configurer configurer) {
            if (configurer != null) {
                configurer.configure(builder);
            }
            this.interceptors.stream().filter(interceptor -> ServiceDescriptor.Configurer.class.isAssignableFrom(interceptor.getClass())).map(ServiceDescriptor.Configurer.class::cast).forEach(interceptor -> interceptor.configure(builder));
            this.register(builder.build());
            return this;
        }
    }
}

