/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.ServerInterceptor;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.GrpcRouting;
import io.helidon.grpc.server.ServiceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class GrpcRoutingImpl
implements GrpcRouting {
    private List<ServiceDescriptor> services;
    private PriorityBag<ServerInterceptor> interceptors;

    private GrpcRoutingImpl(Collection<ServiceDescriptor> services, PriorityBag<ServerInterceptor> interceptors) {
        this.services = new ArrayList<ServiceDescriptor>(Objects.requireNonNull(services));
        this.interceptors = interceptors.copyMe();
    }

    static GrpcRouting create(Collection<ServiceDescriptor> services, PriorityBag<ServerInterceptor> interceptors) {
        return new GrpcRoutingImpl(services, interceptors);
    }

    @Override
    public List<ServiceDescriptor> services() {
        return this.services;
    }

    @Override
    public PriorityBag<ServerInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }
}

