/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.ServerInterceptor;
import io.helidon.common.context.Context;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.ContextSettingServerInterceptor;
import io.helidon.grpc.server.GrpcRouting;
import io.helidon.grpc.server.GrpcServerConfiguration;
import io.helidon.grpc.server.GrpcServerImpl;
import io.helidon.grpc.server.GrpcTracing;
import io.helidon.grpc.server.ServiceDescriptor;
import io.helidon.tracing.Tracer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.health.HealthCheck;

public interface GrpcServer {
    public GrpcServerConfiguration configuration();

    public Context context();

    public CompletionStage<GrpcServer> start();

    public CompletionStage<GrpcServer> whenShutdown();

    public CompletionStage<GrpcServer> shutdown();

    public HealthCheck[] healthChecks();

    public Map<String, ServiceDescriptor> services();

    public boolean isRunning();

    public int port();

    public static GrpcServer create(Supplier<? extends GrpcServerConfiguration> configurationBuilder, GrpcRouting routing) {
        return GrpcServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routing);
    }

    public static GrpcServer create(Supplier<? extends GrpcServerConfiguration> configurationBuilder, Supplier<? extends GrpcRouting> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return GrpcServer.create(configurationBuilder != null ? configurationBuilder.get() : null, routingBuilder.get());
    }

    public static GrpcServer create(GrpcServerConfiguration configuration, Supplier<? extends GrpcRouting> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return GrpcServer.create(configuration, routingBuilder.get());
    }

    public static GrpcServer create(GrpcRouting routing) {
        return GrpcServer.create((GrpcServerConfiguration)null, routing);
    }

    public static GrpcServer create(GrpcServerConfiguration configuration, GrpcRouting routing) {
        Objects.requireNonNull(routing, "Parameter 'routing' is null!");
        return GrpcServer.builder(routing).config(configuration).build();
    }

    public static GrpcServer create(Supplier<? extends GrpcRouting> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return GrpcServer.create(routingBuilder.get());
    }

    public static Builder builder(Supplier<? extends GrpcRouting> routingBuilder) {
        Objects.requireNonNull(routingBuilder, "Parameter 'routingBuilder' must not be null!");
        return GrpcServer.builder(routingBuilder.get());
    }

    public static Builder builder(GrpcRouting routing) {
        return new Builder(GrpcServerConfiguration.create(), routing);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, GrpcServer> {
        private final GrpcRouting routing;
        private GrpcServerConfiguration configuration;

        private Builder(GrpcServerConfiguration configuration, GrpcRouting routing) {
            Objects.requireNonNull(configuration, "Parameter 'configuration' must not be null!");
            Objects.requireNonNull(routing, "Parameter 'routing' must not be null!");
            this.configuration = configuration;
            this.routing = routing;
        }

        public Builder config(GrpcServerConfiguration configuration) {
            this.configuration = configuration != null ? configuration : GrpcServerConfiguration.create();
            return this;
        }

        public Builder config(Supplier<GrpcServerConfiguration> configurationBuilder) {
            this.configuration = configurationBuilder != null ? configurationBuilder.get() : GrpcServerConfiguration.create();
            return this;
        }

        public GrpcServer build() {
            PriorityBag interceptors = PriorityBag.create();
            GrpcServerImpl server = GrpcServerImpl.create(this.configuration);
            interceptors.add((Object)ContextSettingServerInterceptor.create());
            Tracer tracer = this.configuration.tracer();
            if (tracer != null) {
                interceptors.add((Object)GrpcTracing.create(tracer, this.configuration.tracingConfig()));
            }
            interceptors.merge(this.routing.interceptors());
            for (ServiceDescriptor service : this.routing.services()) {
                server.deploy(service, (PriorityBag<ServerInterceptor>)interceptors);
            }
            return server;
        }
    }
}

