/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.helidon.common.context.Context;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import io.helidon.grpc.server.GrpcServerConfiguration;
import io.helidon.grpc.server.GrpcTracingConfig;
import io.helidon.tracing.Tracer;
import java.time.Duration;

public class GrpcServerBasicConfig
implements GrpcServerConfiguration {
    private final String name;
    private final int port;
    private final boolean nativeTransport;
    private final Tracer tracer;
    private final GrpcTracingConfig tracingConfig;
    private final int workers;
    private final GrpcTlsDescriptor tlsConfig;
    private final Context context;
    private final int maxRapidResets;
    private final Duration rapidResetCheckPeriod;

    private GrpcServerBasicConfig(GrpcServerConfiguration.Builder builder) {
        this.name = builder.name();
        this.port = builder.port();
        this.context = builder.context();
        this.nativeTransport = builder.useNativeTransport();
        this.tracer = builder.tracer();
        this.tracingConfig = builder.tracingConfig();
        this.workers = builder.workers();
        this.tlsConfig = builder.tlsConfig();
        this.maxRapidResets = builder.maxRapidResets();
        this.rapidResetCheckPeriod = builder.rapidResetCheckPeriod();
    }

    static GrpcServerBasicConfig create(GrpcServerConfiguration.Builder builder) {
        return new GrpcServerBasicConfig(builder);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public boolean useNativeTransport() {
        return this.nativeTransport;
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public GrpcTracingConfig tracingConfig() {
        return this.tracingConfig;
    }

    @Override
    public int workers() {
        return this.workers;
    }

    @Override
    public GrpcTlsDescriptor tlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public Duration rapidResetCheckPeriod() {
        return this.rapidResetCheckPeriod;
    }

    @Override
    public int maxRapidResets() {
        return this.maxRapidResets;
    }
}

