/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.helidon.common.context.Context;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import io.helidon.grpc.server.GrpcServerBasicConfig;
import io.helidon.grpc.server.GrpcTracingConfig;
import io.helidon.tracing.Tracer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public interface GrpcServerConfiguration {
    public static final String DEFAULT_NAME = "grpc.server";
    public static final int DEFAULT_PORT = 1408;
    public static final int DEFAULT_WORKER_COUNT = Runtime.getRuntime().availableProcessors();

    public String name();

    public int port();

    public Context context();

    public boolean useNativeTransport();

    public Tracer tracer();

    public GrpcTracingConfig tracingConfig();

    public int workers();

    public GrpcTlsDescriptor tlsConfig();

    public Duration rapidResetCheckPeriod();

    public int maxRapidResets();

    public static GrpcServerConfiguration create() {
        return GrpcServerConfiguration.builder().build();
    }

    public static GrpcServerConfiguration create(Config config) {
        return GrpcServerConfiguration.builder(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    @Configured
    public static final class Builder
    implements io.helidon.common.Builder<Builder, GrpcServerConfiguration> {
        private static final AtomicInteger GRPC_SERVER_COUNTER = new AtomicInteger(1);
        private String name = "grpc.server";
        private int port = 1408;
        private boolean useNativeTransport;
        private Tracer tracer;
        private GrpcTracingConfig tracingConfig;
        private int workers;
        private GrpcTlsDescriptor tlsConfig = null;
        private Context context;
        private int maxRapidResets = 200;
        private Duration rapidResetCheckPeriod = Duration.ofSeconds(30L);

        private Builder() {
        }

        public Builder config(Config config) {
            if (config == null) {
                return this;
            }
            this.name = (String)config.get("name").asString().orElse((Object)GrpcServerConfiguration.DEFAULT_NAME);
            this.port = (Integer)config.get("port").asInt().orElse((Object)1408);
            this.maxRapidResets = (Integer)config.get("max-rapid-resets").asInt().orElse((Object)200);
            this.rapidResetCheckPeriod = (Duration)config.get("rapid-reset-check-period").as(Duration.class).orElse((Object)Duration.ofSeconds(30L));
            this.useNativeTransport = (Boolean)config.get("native").asBoolean().orElse((Object)false);
            config.get("workers").asInt().ifPresent(this::workersCount);
            return this;
        }

        public Builder name(String name) {
            this.name = name == null ? null : name.trim();
            return this;
        }

        public Builder port(int port) {
            this.port = port < 0 ? 0 : port;
            return this;
        }

        public Builder rapidResetCheckPeriod(Duration rapidResetCheckPeriod) {
            Objects.requireNonNull(rapidResetCheckPeriod);
            this.rapidResetCheckPeriod = rapidResetCheckPeriod;
            return this;
        }

        public Builder maxRapidResets(int maxRapidResets) {
            this.maxRapidResets = maxRapidResets;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder tracer(Tracer tracer) {
            Objects.requireNonNull(tracer);
            this.tracer = tracer;
            return this;
        }

        public Builder tracer(Supplier<? extends Tracer> tracerBuilder) {
            Objects.requireNonNull(tracerBuilder);
            this.tracer = tracerBuilder.get();
            return this;
        }

        public Builder tracingConfig(GrpcTracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public Builder workersCount(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder tlsConfig(GrpcTlsDescriptor tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        String name() {
            return this.name;
        }

        int port() {
            return this.port;
        }

        public Context context() {
            return this.context;
        }

        Tracer tracer() {
            return this.tracer;
        }

        GrpcTracingConfig tracingConfig() {
            return this.tracingConfig;
        }

        GrpcTlsDescriptor tlsConfig() {
            return this.tlsConfig;
        }

        boolean useNativeTransport() {
            return this.useNativeTransport;
        }

        int workers() {
            return this.workers;
        }

        int maxRapidResets() {
            return this.maxRapidResets;
        }

        Duration rapidResetCheckPeriod() {
            return this.rapidResetCheckPeriod;
        }

        public GrpcServerConfiguration build() {
            if (this.name == null || this.name.isEmpty()) {
                this.name = GrpcServerConfiguration.DEFAULT_NAME;
            }
            if (this.port < 0) {
                this.port = 0;
            }
            if (this.context == null) {
                this.context = Context.builder().id("grpc-" + GRPC_SERVER_COUNTER.getAndIncrement()).build();
            }
            if (this.tracer == null) {
                this.tracer = Tracer.global();
            }
            if (this.tracingConfig == null) {
                this.tracingConfig = GrpcTracingConfig.create();
            }
            if (!this.context.get(Tracer.class).isPresent()) {
                this.context.register((Object)this.tracer);
            }
            if (this.workers <= 0) {
                this.workers = DEFAULT_WORKER_COUNT;
            }
            return GrpcServerBasicConfig.create(this);
        }
    }
}

