/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import io.helidon.common.configurable.Resource;
import io.helidon.common.pki.KeyConfig;
import io.helidon.grpc.core.ContextKeys;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.GrpcServer;
import io.helidon.grpc.server.GrpcServerConfiguration;
import io.helidon.grpc.server.HealthServiceImpl;
import io.helidon.grpc.server.ProtoReflectionService;
import io.helidon.grpc.server.SSLContextBuilder;
import io.helidon.grpc.server.ServiceDescriptor;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import jakarta.annotation.Priority;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.health.HealthCheck;

public class GrpcServerImpl
implements GrpcServer {
    private CompletableFuture<GrpcServer> startFuture = new CompletableFuture();
    private CompletableFuture<GrpcServer> shutdownFuture = new CompletableFuture();
    private static final Logger LOGGER = Logger.getLogger(GrpcServerImpl.class.getName());
    private GrpcServerConfiguration config;
    private Server server;
    private Server inProcessServer;
    private HealthServiceImpl healthService = HealthServiceImpl.create();
    private final MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
    private Map<String, ServerServiceDefinition> mapServices = new ConcurrentHashMap<String, ServerServiceDefinition>();
    private Map<String, ServiceDescriptor> services = new ConcurrentHashMap<String, ServiceDescriptor>();
    private final io.helidon.common.context.Context context;

    private GrpcServerImpl(GrpcServerConfiguration config) {
        this.config = config;
        this.context = config.context();
    }

    static GrpcServerImpl create(GrpcServerConfiguration config) {
        return new GrpcServerImpl(config);
    }

    @Override
    public CompletionStage<GrpcServer> start() {
        String sName = this.config.name();
        int port = this.config.port();
        boolean tls = false;
        GrpcTlsDescriptor tlsConfig = this.config.tlsConfig();
        SslContext sslContext = null;
        try {
            if (tlsConfig != null) {
                if (tlsConfig.isJdkSSL()) {
                    SSLContext sslCtx = SSLContextBuilder.create(KeyConfig.pemBuilder().key(tlsConfig.tlsKey()).certChain(tlsConfig.tlsCert()).build()).build();
                    sslContext = new JdkSslContext(sslCtx, false, ClientAuth.NONE);
                } else {
                    sslContext = this.sslContextBuilder(tlsConfig).build();
                }
            }
            NettyServerBuilder builder = sslContext == null ? NettyServerBuilder.forPort((int)port) : NettyServerBuilder.forPort((int)port).sslContext(sslContext);
            MutableHandlerRegistry handlerRegistry = this.handlerRegistry;
            int maxRapidResets = this.config.maxRapidResets();
            Duration rapidResetCheckPeriod = this.config.rapidResetCheckPeriod();
            this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)this.configureNetty(builder).directExecutor()).addService((BindableService)this.healthService)).addService(ProtoReflectionService.newInstance())).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).maxRstFramesPerWindow(maxRapidResets, (int)rapidResetCheckPeriod.toSeconds()).build().start();
            this.inProcessServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)sName).addService((BindableService)this.healthService)).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).build().start();
            LOGGER.log(Level.INFO, () -> String.format("gRPC server [%s]: listening on port %d (TLS=%s)", sName, this.server.getPort(), tls));
            Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
            this.startFuture.complete(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.log(Level.SEVERE, String.format("gRPC server [%s]: failed to start on port %d (TLS=%s)", sName, port, tls), e);
            this.startFuture.completeExceptionally(e);
        }
        return this.startFuture;
    }

    @Override
    public CompletionStage<GrpcServer> shutdown() {
        String name = this.config.name();
        try {
            if (this.server != null) {
                this.server.shutdown();
                this.inProcessServer.shutdown();
                this.server.awaitTermination();
                this.inProcessServer.awaitTermination();
                LOGGER.log(Level.INFO, () -> String.format("gRPC server [%s]: server stopped", name));
                this.server = null;
                this.inProcessServer = null;
                this.shutdownFuture.complete(this);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, String.format("gRPC server [%s]: server failed to shut down", name), e);
            this.shutdownFuture.completeExceptionally(e);
        }
        return this.shutdownFuture;
    }

    @Override
    public GrpcServerConfiguration configuration() {
        return this.config;
    }

    @Override
    public io.helidon.common.context.Context context() {
        return this.context;
    }

    @Override
    public CompletionStage<GrpcServer> whenShutdown() {
        return this.shutdownFuture;
    }

    @Override
    public boolean isRunning() {
        return this.server != null && !this.server.isShutdown() && !this.server.isTerminated();
    }

    @Override
    public int port() {
        return this.isRunning() ? this.server.getPort() : -1;
    }

    @Override
    public HealthCheck[] healthChecks() {
        return this.healthService.healthChecks().toArray(new HealthCheck[0]);
    }

    @Override
    public Map<String, ServiceDescriptor> services() {
        return Collections.unmodifiableMap(this.services);
    }

    private NettyServerBuilder configureNetty(NettyServerBuilder builder) {
        int workersCount = this.config.workers();
        Class<NioServerSocketChannel> channelType = null;
        NioEventLoopGroup boss = null;
        NioEventLoopGroup workers = null;
        if (channelType == null) {
            LOGGER.log(Level.FINE, () -> "Using NIO transport");
            channelType = NioServerSocketChannel.class;
            boss = new NioEventLoopGroup(1);
            ThreadPerTaskExecutor executor = new ThreadPerTaskExecutor((ThreadFactory)((Object)new ContextAwareThreadFactory(NioEventLoopGroup.class)));
            workers = workersCount <= 0 ? new NioEventLoopGroup(0, (Executor)executor) : new NioEventLoopGroup(workersCount, (Executor)executor);
        }
        return builder.channelType(channelType).bossEventLoopGroup(boss).workerEventLoopGroup(workers);
    }

    public void deploy(ServiceDescriptor serviceDescriptor, PriorityBag<ServerInterceptor> globalInterceptors) {
        Objects.requireNonNull(serviceDescriptor);
        Objects.requireNonNull(globalInterceptors);
        globalInterceptors.add((Object)new ContextAwareServerInterceptor());
        String serverName = this.config.name();
        BindableService service = serviceDescriptor.bindableService(globalInterceptors);
        ServerServiceDefinition ssd = service.bindService();
        String serviceName = ssd.getServiceDescriptor().getName();
        this.services.put(serviceDescriptor.name(), serviceDescriptor);
        this.handlerRegistry.addService(ssd);
        this.mapServices.put(service.getClass().getName(), ssd);
        this.healthService.add(serviceName, serviceDescriptor.healthCheck());
        LOGGER.info(() -> String.format("gRPC server [%s]: registered service [%s]", serverName, serviceName));
        Iterator methods = ssd.getMethods().stream().map(ServerMethodDefinition::getMethodDescriptor).map(MethodDescriptor::getFullMethodName).sorted().iterator();
        if (methods.hasNext()) {
            LOGGER.info(() -> String.format("gRPC server [%s]:       with methods [%s]", serverName, methods.next()));
        }
        while (methods.hasNext()) {
            LOGGER.info(() -> String.format("gRPC server [%s]:                    [%s]", serverName, methods.next()));
        }
    }

    public void undeploy(BindableService service, String sName) {
        Objects.requireNonNull(service);
        String serviceClassName = service.getClass().getName();
        ServerServiceDefinition ssd = this.mapServices.get(serviceClassName);
        if (null == ssd) {
            return;
        }
        this.handlerRegistry.removeService(ssd);
        this.mapServices.remove(serviceClassName);
        LOGGER.info(() -> String.format("gRPC server [%s]: unregistered service [%s]", sName, ssd.getServiceDescriptor().getName()));
    }

    public List<ServerServiceDefinition> getServices() {
        return Collections.unmodifiableList(this.handlerRegistry.getServices());
    }

    public ManagedChannel createInProcessChannel() {
        return InProcessChannelBuilder.forName((String)this.config.name()).build();
    }

    protected SslContextBuilder sslContextBuilder(GrpcTlsDescriptor tlsConfig) {
        X509Certificate[] aX509Certificates;
        Resource certResource = tlsConfig.tlsCert();
        Resource keyResource = tlsConfig.tlsKey();
        Resource caCertResource = tlsConfig.tlsCaCert();
        if (certResource == null) {
            throw new IllegalStateException("gRPC server is configured to use TLS but cert file is not set");
        }
        if (keyResource == null) {
            throw new IllegalStateException("gRPC server is configured to use TLS but key file is not set");
        }
        if (caCertResource != null) {
            try {
                aX509Certificates = GrpcServerImpl.loadX509Cert(caCertResource.stream());
            }
            catch (Exception e) {
                throw new IllegalStateException("gRPC server is configured to use TLS but failed to load trusted CA files");
            }
        } else {
            aX509Certificates = new X509Certificate[]{};
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((InputStream)certResource.stream(), (InputStream)keyResource.stream()).sslProvider(SslProvider.OPENSSL);
        if (aX509Certificates.length > 0) {
            sslContextBuilder.trustManager(aX509Certificates).clientAuth(ClientAuth.REQUIRE);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.OPTIONAL);
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
    }

    private static X509Certificate[] loadX509Cert(InputStream in) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate[] certs = new X509Certificate[]{(X509Certificate)cf.generateCertificate(in)};
        return certs;
    }

    private class ContextAwareThreadFactory
    extends DefaultThreadFactory {
        private ContextAwareThreadFactory(Class<?> poolType) {
            super(poolType);
        }

        public Thread newThread(Runnable runnable) {
            return super.newThread(() -> {
                io.helidon.common.context.Context context = io.helidon.common.context.Context.create((io.helidon.common.context.Context)GrpcServerImpl.this.context());
                io.helidon.common.context.Contexts.runInContext((io.helidon.common.context.Context)context, (Runnable)runnable);
            });
        }
    }

    @Priority(value=999)
    private class ContextAwareServerInterceptor
    implements ServerInterceptor {
        private ContextAwareServerInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            io.helidon.common.context.Context context = io.helidon.common.context.Context.create((io.helidon.common.context.Context)GrpcServerImpl.this.context());
            Context grpcContext = Context.current().withValue(ContextKeys.HELIDON_CONTEXT, (Object)context);
            return Contexts.interceptCall((Context)grpcContext, call, (Metadata)headers, next);
        }
    }
}

