/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.helidon.grpc.core.ContextKeys;
import io.helidon.grpc.core.GrpcTracingContext;
import io.helidon.grpc.core.GrpcTracingName;
import io.helidon.grpc.server.GrpcTracingConfig;
import io.helidon.grpc.server.ServerRequestAttribute;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import jakarta.annotation.Priority;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;

@Priority(value=1001)
public class GrpcTracing
implements ServerInterceptor {
    private final Tracer tracer;
    private final GrpcTracingName operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ServerRequestAttribute> tracedAttributes;

    private GrpcTracing(Tracer tracer, GrpcTracingConfig tracingConfig) {
        this.tracer = tracer;
        this.operationNameConstructor = tracingConfig.operationNameConstructor();
        this.streaming = tracingConfig.isStreaming();
        this.verbose = tracingConfig.isVerbose();
        this.tracedAttributes = tracingConfig.tracedAttributes();
    }

    static GrpcTracing create(Tracer tracer, GrpcTracingConfig config) {
        return new GrpcTracing(tracer, config);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : headers.keys()) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        String operationName = this.operationNameConstructor.name(call.getMethodDescriptor());
        Span span = this.getSpanFromHeaders(headerMap, operationName);
        if (this.tracedAttributes.contains((Object)ServerRequestAttribute.ALL)) {
            span.tag("grpc.method_type", call.getMethodDescriptor().getType().toString());
            span.tag("grpc.method_name", call.getMethodDescriptor().getFullMethodName());
            span.tag("grpc.call_attributes", call.getAttributes().toString());
            this.addMetadata(headers, span);
        } else {
            for (ServerRequestAttribute attr : this.tracedAttributes) {
                switch (attr) {
                    case METHOD_TYPE: {
                        span.tag("grpc.method_type", call.getMethodDescriptor().getType().toString());
                        break;
                    }
                    case METHOD_NAME: {
                        span.tag("grpc.method_name", call.getMethodDescriptor().getFullMethodName());
                        break;
                    }
                    case CALL_ATTRIBUTES: {
                        span.tag("grpc.call_attributes", call.getAttributes().toString());
                        break;
                    }
                    case HEADERS: {
                        this.addMetadata(headers, span);
                        break;
                    }
                }
            }
        }
        Context grpcContext = Context.current();
        this.updateContext((io.helidon.common.context.Context)ContextKeys.HELIDON_CONTEXT.get(grpcContext), span);
        io.helidon.common.context.Contexts.context().ifPresent(ctx -> this.updateContext((io.helidon.common.context.Context)ctx, span));
        Context ctxWithSpan = grpcContext.withValue(GrpcTracingContext.SPAN_KEY, (Object)span);
        ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, call, (Metadata)headers, next);
        return new TracingListener(listenerWithContext, span);
    }

    private void updateContext(io.helidon.common.context.Context context, Span span) {
        if (context != null) {
            if (!context.get(Tracer.class).isPresent()) {
                context.register((Object)this.tracer);
            }
            context.register((Object)span.context());
        }
    }

    private void addMetadata(Metadata headers, Span span) {
        Metadata metadata = new Metadata();
        metadata.merge(headers);
        metadata.removeAll(ContextKeys.AUTHORIZATION);
        span.tag("grpc.headers", metadata.toString());
    }

    private Span getSpanFromHeaders(Map<String, String> headers, String operationName) {
        Span span;
        try {
            SpanContext parentSpanCtx = this.tracer.extract((HeaderProvider)new MapHeaderProvider(headers)).orElse(null);
            span = parentSpanCtx == null ? this.tracer.spanBuilder(operationName).start() : this.tracer.spanBuilder(operationName).parent(parentSpanCtx).start();
        }
        catch (IllegalArgumentException iae) {
            span = this.tracer.spanBuilder(operationName).tag("Error", "Extract failed and an IllegalArgumentException was thrown").start();
        }
        return span;
    }

    private static boolean isCaseInsensitive(Map<String, String> headers) {
        return headers instanceof TreeMap && ((TreeMap)headers).comparator() == String.CASE_INSENSITIVE_ORDER || headers instanceof ConcurrentSkipListMap && ((ConcurrentSkipListMap)headers).comparator() == String.CASE_INSENSITIVE_ORDER;
    }

    private class TracingListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final Span span;

        private TracingListener(ServerCall.Listener<ReqT> delegate, Span span) {
            super(delegate);
            this.span = span;
        }

        public void onMessage(ReqT message) {
            if (GrpcTracing.this.streaming || GrpcTracing.this.verbose) {
                this.span.addEvent("onMessage", Map.of("Message received", message));
            }
            this.delegate().onMessage(message);
        }

        public void onHalfClose() {
            if (GrpcTracing.this.streaming) {
                this.span.addEvent("Client finished sending messages");
            }
            this.delegate().onHalfClose();
        }

        public void onCancel() {
            this.span.addEvent("Call cancelled");
            try {
                this.delegate().onCancel();
            }
            finally {
                this.span.end();
            }
        }

        public void onComplete() {
            if (GrpcTracing.this.verbose) {
                this.span.addEvent("Call completed");
            }
            try {
                this.delegate().onComplete();
            }
            finally {
                this.span.end();
            }
        }
    }

    private static class MapHeaderProvider
    implements HeaderProvider {
        private final Map<String, String> headers;

        MapHeaderProvider(Map<String, String> headers) {
            if (GrpcTracing.isCaseInsensitive(headers)) {
                this.headers = headers;
            } else {
                this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                this.headers.putAll(headers);
            }
        }

        public Iterable<String> keys() {
            return this.headers.keySet();
        }

        public Optional<String> get(String key) {
            return Optional.ofNullable(this.headers.get(key));
        }

        public Iterable<String> getAll(String key) {
            return this.get(key).map(List::of).orElseGet(List::of);
        }

        public boolean contains(String key) {
            return this.headers.containsKey(key);
        }
    }
}

