/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.MethodDescriptor;
import io.helidon.grpc.core.GrpcTracingName;
import io.helidon.grpc.server.ServerRequestAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class GrpcTracingConfig {
    private final GrpcTracingName operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ServerRequestAttribute> tracedAttributes;

    GrpcTracingConfig(GrpcTracingName operationNameConstructor, Set<ServerRequestAttribute> tracedAttributes, boolean streaming, boolean verbose) {
        this.operationNameConstructor = operationNameConstructor;
        this.tracedAttributes = tracedAttributes;
        this.streaming = streaming;
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Set<ServerRequestAttribute> tracedAttributes() {
        return this.tracedAttributes;
    }

    public GrpcTracingName operationNameConstructor() {
        return this.operationNameConstructor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GrpcTracingConfig create() {
        return GrpcTracingConfig.builder().build();
    }

    public static class Builder {
        private GrpcTracingName operationNameConstructor = MethodDescriptor::getFullMethodName;
        private boolean streaming = false;
        private boolean verbose = false;
        private Set<ServerRequestAttribute> tracedAttributes = Collections.emptySet();

        Builder() {
        }

        public Builder withOperationName(GrpcTracingName operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withTracedAttributes(ServerRequestAttribute ... attributes) {
            this.tracedAttributes = new HashSet<ServerRequestAttribute>(Arrays.asList(attributes));
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public GrpcTracingConfig build() {
            return new GrpcTracingConfig(this.operationNameConstructor, this.tracedAttributes, this.streaming, this.verbose);
        }
    }
}

