/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import io.grpc.Status;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.StreamObserver;
import io.helidon.grpc.server.ConstantHealthCheck;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

class HealthServiceImpl
extends HealthGrpc.HealthImplBase {
    private final Map<String, HealthCheck> mapHealthChecks = new ConcurrentHashMap<String, HealthCheck>();

    private HealthServiceImpl() {
        this.mapHealthChecks.put("", ConstantHealthCheck.up(""));
    }

    static HealthServiceImpl create() {
        return new HealthServiceImpl();
    }

    void add(String name, HealthCheck healthCheck) {
        this.mapHealthChecks.put(name, healthCheck);
    }

    Collection<HealthCheck> healthChecks() {
        return this.mapHealthChecks.values();
    }

    public void check(HealthCheckRequest request, StreamObserver<io.grpc.health.v1.HealthCheckResponse> responseObserver) {
        String service = request.getService();
        HealthCheck check = this.mapHealthChecks.get(service);
        if (check == null) {
            String message = "Service '" + service + "' does not exist or does not have a registered health check";
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(message).asException());
        } else {
            responseObserver.onNext((Object)this.toHealthCheckResponse(check.call()));
            responseObserver.onCompleted();
        }
    }

    private io.grpc.health.v1.HealthCheckResponse toHealthCheckResponse(HealthCheckResponse.ServingStatus status) {
        return io.grpc.health.v1.HealthCheckResponse.newBuilder().setStatus(status).build();
    }

    private io.grpc.health.v1.HealthCheckResponse toHealthCheckResponse(HealthCheckResponse response) {
        return response.getStatus().equals((Object)HealthCheckResponse.Status.UP) ? this.toHealthCheckResponse(HealthCheckResponse.ServingStatus.SERVING) : this.toHealthCheckResponse(HealthCheckResponse.ServingStatus.NOT_SERVING);
    }
}

