/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import com.google.protobuf.Any;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.InternalServer;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.reflection.v1alpha.ErrorResponse;
import io.grpc.reflection.v1alpha.ExtensionNumberResponse;
import io.grpc.reflection.v1alpha.ExtensionRequest;
import io.grpc.reflection.v1alpha.FileDescriptorResponse;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.reflection.v1alpha.ServiceResponse;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class ProtoReflectionService
extends ServerReflectionGrpc.ServerReflectionImplBase {
    private final Lock indexAccess = new ReentrantLock(true);
    private final Map<Server, ServerReflectionIndex> serverReflectionIndexes = new WeakHashMap<Server, ServerReflectionIndex>();

    private ProtoReflectionService() {
    }

    public static BindableService newInstance() {
        return new ProtoReflectionService();
    }

    private ServerReflectionIndex getRefreshedIndex() {
        return this.accessIndex(() -> {
            Server server = (Server)InternalServer.SERVER_CONTEXT_KEY.get();
            ServerReflectionIndex index = this.serverReflectionIndexes.get(server);
            if (index == null) {
                index = new ServerReflectionIndex(server.getImmutableServices(), server.getMutableServices());
                this.serverReflectionIndexes.put(server, index);
                return index;
            }
            HashSet<Descriptors.FileDescriptor> serverFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
            HashSet<String> serverServiceNames = new HashSet<String>();
            List serverMutableServices = server.getMutableServices();
            for (ServerServiceDefinition mutableService : serverMutableServices) {
                ServiceDescriptor serviceDescriptor = mutableService.getServiceDescriptor();
                if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                String serviceName = serviceDescriptor.getName();
                Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                serverFileDescriptors.add(fileDescriptor);
                serverServiceNames.add(serviceName);
            }
            FileDescriptorIndex mutableServicesIndex = index.getMutableServicesIndex();
            if (!mutableServicesIndex.getServiceFileDescriptors().equals(serverFileDescriptors) || !mutableServicesIndex.getServiceNames().equals(serverServiceNames)) {
                index = new ServerReflectionIndex(server.getImmutableServices(), serverMutableServices);
                this.serverReflectionIndexes.put(server, index);
            }
            return index;
        });
    }

    public StreamObserver<ServerReflectionRequest> serverReflectionInfo(StreamObserver<ServerReflectionResponse> responseObserver) {
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        ProtoReflectionStreamObserver requestObserver = new ProtoReflectionStreamObserver(this.getRefreshedIndex(), (ServerCallStreamObserver<ServerReflectionResponse>)serverCallStreamObserver);
        serverCallStreamObserver.setOnReadyHandler((Runnable)requestObserver);
        serverCallStreamObserver.disableAutoRequest();
        serverCallStreamObserver.request(1);
        return requestObserver;
    }

    private <T> T accessIndex(Supplier<T> operation) {
        this.indexAccess.lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.indexAccess.unlock();
        }
    }

    private static final class ServerReflectionIndex {
        private final FileDescriptorIndex immutableServicesIndex;
        private final FileDescriptorIndex mutableServicesIndex;

        ServerReflectionIndex(List<ServerServiceDefinition> immutableServices, List<ServerServiceDefinition> mutableServices) {
            this.immutableServicesIndex = new FileDescriptorIndex(immutableServices);
            this.mutableServicesIndex = new FileDescriptorIndex(mutableServices);
        }

        private FileDescriptorIndex getMutableServicesIndex() {
            return this.mutableServicesIndex;
        }

        private Set<String> getServiceNames() {
            Set<String> immutableServiceNames = this.immutableServicesIndex.getServiceNames();
            Set<String> mutableServiceNames = this.mutableServicesIndex.getServiceNames();
            HashSet<String> serviceNames = new HashSet<String>(immutableServiceNames.size() + mutableServiceNames.size());
            serviceNames.addAll(immutableServiceNames);
            serviceNames.addAll(mutableServiceNames);
            return serviceNames;
        }

        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByName(name);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorByName(name);
            }
            return fd;
        }

        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorBySymbol(symbol);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorBySymbol(symbol);
            }
            return fd;
        }

        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int extension) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            }
            return fd;
        }

        private Set<Integer> getExtensionNumbersOfType(String type) {
            Set<Integer> extensionNumbers = this.immutableServicesIndex.getExtensionNumbersOfType(type);
            if (extensionNumbers == null) {
                extensionNumbers = this.mutableServicesIndex.getExtensionNumbersOfType(type);
            }
            return extensionNumbers;
        }
    }

    private static class ProtoReflectionStreamObserver
    implements Runnable,
    StreamObserver<ServerReflectionRequest> {
        private final ServerReflectionIndex serverReflectionIndex;
        private final ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver;
        private boolean closeAfterSend = false;
        private ServerReflectionRequest request;

        ProtoReflectionStreamObserver(ServerReflectionIndex serverReflectionIndex, ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver) {
            this.serverReflectionIndex = serverReflectionIndex;
            this.serverCallStreamObserver = Objects.requireNonNull(serverCallStreamObserver, "observer");
        }

        @Override
        public void run() {
            if (this.request != null) {
                this.handleReflectionRequest();
            }
        }

        public void onNext(ServerReflectionRequest request) {
            this.request = Objects.requireNonNull(request);
            this.handleReflectionRequest();
        }

        private void handleReflectionRequest() {
            if (this.serverCallStreamObserver.isReady()) {
                switch (this.request.getMessageRequestCase()) {
                    case FILE_BY_FILENAME: {
                        this.getFileByName(this.request);
                        break;
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        this.getFileContainingSymbol(this.request);
                        break;
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        this.getFileByExtension(this.request);
                        break;
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        this.getAllExtensions(this.request);
                        break;
                    }
                    case LIST_SERVICES: {
                        this.listServices(this.request);
                        break;
                    }
                    default: {
                        this.sendErrorResponse(this.request, Status.Code.UNIMPLEMENTED, "not implemented " + this.request.getMessageRequestCase());
                    }
                }
                this.request = null;
                if (this.closeAfterSend) {
                    this.serverCallStreamObserver.onCompleted();
                } else {
                    this.serverCallStreamObserver.request(1);
                }
            }
        }

        public void onCompleted() {
            if (this.request != null) {
                this.closeAfterSend = true;
            } else {
                this.serverCallStreamObserver.onCompleted();
            }
        }

        public void onError(Throwable cause) {
            this.serverCallStreamObserver.onError(cause);
        }

        private void getFileByName(ServerReflectionRequest request) {
            String name = request.getFileByFilename();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorByName(name);
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "File not found.");
            }
        }

        private void getFileContainingSymbol(ServerReflectionRequest request) {
            String symbol = request.getFileContainingSymbol();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorBySymbol(symbol);
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.getFileContainingSymbolFromServer(request);
            }
        }

        private void getFileContainingSymbolFromServer(ServerReflectionRequest request) {
            Server server = (Server)InternalServer.SERVER_CONTEXT_KEY.get();
            String symbol = request.getFileContainingSymbol();
            try {
                ServerServiceDefinition service = server.getServices().stream().filter(s -> s.getServiceDescriptor().getName().equals(symbol)).findFirst().orElse(null);
                if (service != null) {
                    this.sendServiceDetails(request, service, null);
                } else {
                    this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found.");
                }
            }
            catch (Throwable e) {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found.");
            }
        }

        private void sendServiceDetails(ServerReflectionRequest request, ServerServiceDefinition service, ServerMethodDefinition method) throws Descriptors.DescriptorValidationException {
            String name = service.getServiceDescriptor().getName();
            DescriptorProtos.ServiceDescriptorProto.Builder serviceDesc = DescriptorProtos.ServiceDescriptorProto.newBuilder().setName(name.substring(name.lastIndexOf(46) + 1));
            Set<ServerMethodDefinition> methods = method == null ? service.getMethods() : Set.of(method);
            for (ServerMethodDefinition m : methods) {
                MethodDescriptor md = m.getMethodDescriptor();
                serviceDesc.addMethod(DescriptorProtos.MethodDescriptorProto.newBuilder().setName(md.getBareMethodName()).setServerStreaming(EnumSet.of(MethodDescriptor.MethodType.SERVER_STREAMING, MethodDescriptor.MethodType.BIDI_STREAMING).contains(md.getType())).setClientStreaming(EnumSet.of(MethodDescriptor.MethodType.CLIENT_STREAMING, MethodDescriptor.MethodType.BIDI_STREAMING).contains(md.getType())).setInputType(Any.getDescriptor().getFullName()).setOutputType(Any.getDescriptor().getFullName()).build());
            }
            DescriptorProtos.FileDescriptorProto fileDesc = DescriptorProtos.FileDescriptorProto.newBuilder().setPackage(name.substring(0, name.lastIndexOf(46))).addDependency(Any.getDescriptor().getFile().getFullName()).addService(serviceDesc).build();
            this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDesc, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[]{Any.getDescriptor().getFile()}, (boolean)true)));
        }

        private void getFileByExtension(ServerReflectionRequest request) {
            int extension;
            ExtensionRequest extensionRequest = request.getFileContainingExtension();
            String type = extensionRequest.getContainingType();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorByExtensionAndNumber(type, extension = extensionRequest.getExtensionNumber());
            if (fd != null) {
                this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Extension not found.");
            }
        }

        private void getAllExtensions(ServerReflectionRequest request) {
            String type = request.getAllExtensionNumbersOfType();
            Set<Integer> extensions = this.serverReflectionIndex.getExtensionNumbersOfType(type);
            if (extensions != null) {
                ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
                this.serverCallStreamObserver.onNext((Object)ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build());
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Type not found.");
            }
        }

        private void listServices(ServerReflectionRequest request) {
            ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
            for (String serviceName : this.serverReflectionIndex.getServiceNames()) {
                builder.addService(ServiceResponse.newBuilder().setName(serviceName));
            }
            Server server = (Server)InternalServer.SERVER_CONTEXT_KEY.get();
            for (ServerServiceDefinition def : server.getServices()) {
                if (def.getServiceDescriptor().getSchemaDescriptor() != null) continue;
                builder.addService(ServiceResponse.newBuilder().setName(def.getServiceDescriptor().getName()));
            }
            this.serverCallStreamObserver.onNext((Object)ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(builder).build());
        }

        private void sendErrorResponse(ServerReflectionRequest request, Status.Code code, String message) {
            ServerReflectionResponse response = ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.value()).setErrorMessage(message)).build();
            this.serverCallStreamObserver.onNext((Object)response);
        }

        private ServerReflectionResponse createServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
            FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
            HashSet<String> seenFiles = new HashSet<String>();
            ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
            seenFiles.add(fd.getName());
            frontier.add(fd);
            while (!frontier.isEmpty()) {
                Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
                fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
                for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    frontier.add(dependencyFd);
                }
            }
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
        }
    }

    private static final class FileDescriptorIndex {
        private final Set<String> serviceNames = new HashSet<String>();
        private final Set<Descriptors.FileDescriptor> serviceFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsByName = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsBySymbol = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Map<Integer, Descriptors.FileDescriptor>> fileDescriptorsByExtensionAndNumber = new HashMap<String, Map<Integer, Descriptors.FileDescriptor>>();

        FileDescriptorIndex(List<ServerServiceDefinition> services) {
            ArrayDeque<Descriptors.FileDescriptor> fileDescriptorsToProcess = new ArrayDeque<Descriptors.FileDescriptor>();
            HashSet<String> seenFiles = new HashSet<String>();
            for (ServerServiceDefinition service : services) {
                ServiceDescriptor serviceDescriptor = service.getServiceDescriptor();
                if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                String serviceName = serviceDescriptor.getName();
                this.serviceFileDescriptors.add(fileDescriptor);
                this.serviceNames.add(serviceName);
                if (seenFiles.contains(fileDescriptor.getName())) continue;
                seenFiles.add(fileDescriptor.getName());
                fileDescriptorsToProcess.add(fileDescriptor);
            }
            while (!fileDescriptorsToProcess.isEmpty()) {
                Descriptors.FileDescriptor currentFd = (Descriptors.FileDescriptor)fileDescriptorsToProcess.remove();
                this.processFileDescriptor(currentFd);
                for (Descriptors.FileDescriptor dependencyFd : currentFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    fileDescriptorsToProcess.add(dependencyFd);
                }
            }
        }

        private Set<Descriptors.FileDescriptor> getServiceFileDescriptors() {
            return Collections.unmodifiableSet(this.serviceFileDescriptors);
        }

        private Set<String> getServiceNames() {
            return Collections.unmodifiableSet(this.serviceNames);
        }

        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            return this.fileDescriptorsByName.get(name);
        }

        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            return this.fileDescriptorsBySymbol.get(symbol);
        }

        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int number) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return this.fileDescriptorsByExtensionAndNumber.get(type).get(number);
            }
            return null;
        }

        private Set<Integer> getExtensionNumbersOfType(String type) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return Collections.unmodifiableSet(this.fileDescriptorsByExtensionAndNumber.get(type).keySet());
            }
            return null;
        }

        private void processFileDescriptor(Descriptors.FileDescriptor fd) {
            String fdName = fd.getName();
            this.fileDescriptorsByName.put(fdName, fd);
            for (Descriptors.ServiceDescriptor service : fd.getServices()) {
                this.processService(service, fd);
            }
            for (Descriptors.Descriptor type : fd.getMessageTypes()) {
                this.processType(type, fd);
            }
            for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
                this.processExtension(extension, fd);
            }
        }

        private void processService(Descriptors.ServiceDescriptor service, Descriptors.FileDescriptor fd) {
            String serviceName = service.getFullName();
            this.fileDescriptorsBySymbol.put(serviceName, fd);
            for (Descriptors.MethodDescriptor method : service.getMethods()) {
                String methodName = method.getFullName();
                this.fileDescriptorsBySymbol.put(methodName, fd);
            }
        }

        private void processType(Descriptors.Descriptor type, Descriptors.FileDescriptor fd) {
            String typeName = type.getFullName();
            this.fileDescriptorsBySymbol.put(typeName, fd);
            for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
                this.processExtension(extension, fd);
            }
            for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
                this.processType(nestedType, fd);
            }
        }

        private void processExtension(Descriptors.FieldDescriptor extension, Descriptors.FileDescriptor fd) {
            String extensionName = extension.getContainingType().getFullName();
            int extensionNumber = extension.getNumber();
            if (!this.fileDescriptorsByExtensionAndNumber.containsKey(extensionName)) {
                this.fileDescriptorsByExtensionAndNumber.put(extensionName, new HashMap());
            }
            this.fileDescriptorsByExtensionAndNumber.get(extensionName).put(extensionNumber, fd);
        }
    }
}

