/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.server;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.stub.ServerCalls;
import io.helidon.grpc.core.GrpcHelper;
import io.helidon.grpc.core.MarshallerSupplier;
import io.helidon.grpc.core.PriorityBag;
import io.helidon.grpc.server.BindableServiceImpl;
import io.helidon.grpc.server.ConstantHealthCheck;
import io.helidon.grpc.server.GrpcService;
import io.helidon.grpc.server.MethodDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.health.HealthCheck;

public class ServiceDescriptor {
    public static final Context.Key<ServiceDescriptor> SERVICE_DESCRIPTOR_KEY = Context.key((String)"Helidon.ServiceDescriptor");
    private final String name;
    private final String fullName;
    private final String packageName;
    private final Map<String, MethodDescriptor> methods;
    private final PriorityBag<ServerInterceptor> interceptors;
    private final Map<Context.Key<?>, Object> context;
    private final HealthCheck healthCheck;
    private final Descriptors.FileDescriptor proto;

    private ServiceDescriptor(String name, Map<String, MethodDescriptor> methods, PriorityBag<ServerInterceptor> interceptors, Map<Context.Key<?>, Object> context, HealthCheck healthCheck, Descriptors.FileDescriptor proto) {
        String assignedName = Objects.requireNonNull(name);
        this.methods = methods;
        this.context = Collections.unmodifiableMap(context);
        this.healthCheck = healthCheck;
        this.interceptors = interceptors.copyMe();
        this.proto = proto;
        this.packageName = proto == null ? "" : proto.getPackage();
        String servicePrefix = this.packageName + (!this.packageName.isEmpty() ? "." : "");
        if (!servicePrefix.isEmpty() && assignedName.startsWith(servicePrefix)) {
            this.name = assignedName.replace(servicePrefix, "");
            this.fullName = assignedName;
        } else {
            this.name = assignedName;
            this.fullName = servicePrefix + assignedName;
        }
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.fullName;
    }

    public String packageName() {
        return this.packageName;
    }

    public MethodDescriptor method(String name) {
        return this.methods.get(name);
    }

    public Collection<MethodDescriptor> methods() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public PriorityBag<ServerInterceptor> interceptors() {
        return this.interceptors.readOnly();
    }

    public Map<Context.Key<?>, Object> context() {
        return this.context;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public Descriptors.FileDescriptor proto() {
        return this.proto;
    }

    BindableService bindableService(PriorityBag<ServerInterceptor> interceptors) {
        return BindableServiceImpl.create(this, interceptors);
    }

    public String toString() {
        return "ServiceDescriptor(name='" + this.fullName + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDescriptor that = (ServiceDescriptor)o;
        return this.fullName.equals(that.fullName);
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    public static Builder builder(Class serviceClass, String name) {
        return new Builder(serviceClass, name);
    }

    public static Builder builder(GrpcService service) {
        return new Builder(service);
    }

    public static Builder builder(BindableService service) {
        return new Builder(service);
    }

    public static final class Builder
    implements Rules,
    io.helidon.common.Builder<Builder, ServiceDescriptor> {
        private final Class<?> serviceClass;
        private String name;
        private Descriptors.FileDescriptor proto;
        private MarshallerSupplier marshallerSupplier = MarshallerSupplier.defaultInstance();
        private Map<String, MethodDescriptor.Builder> methodBuilders = new LinkedHashMap<String, MethodDescriptor.Builder>();
        private PriorityBag<ServerInterceptor> interceptors = PriorityBag.withDefaultPriority((int)5000);
        private Map<Context.Key<?>, Object> context = new HashMap();
        private HealthCheck healthCheck;

        Builder(Class<?> serviceClass, String name) {
            this.name = name == null || name.trim().isEmpty() ? serviceClass.getSimpleName() : name.trim();
            this.serviceClass = serviceClass;
            this.healthCheck = ConstantHealthCheck.up(name);
        }

        Builder(GrpcService service) {
            this.name = service.name();
            this.serviceClass = service.getClass();
            this.healthCheck = ConstantHealthCheck.up(this.name);
            service.update(this);
        }

        Builder(BindableService service) {
            ServerServiceDefinition def = service.bindService();
            this.name = def.getServiceDescriptor().getName();
            this.serviceClass = service.getClass();
            this.healthCheck = ConstantHealthCheck.up(this.name);
            Object schemaDescriptor = def.getServiceDescriptor().getSchemaDescriptor();
            if (schemaDescriptor instanceof ProtoFileDescriptorSupplier) {
                this.proto = ((ProtoFileDescriptorSupplier)schemaDescriptor).getFileDescriptor();
            }
            for (ServerMethodDefinition smd : def.getMethods()) {
                io.grpc.MethodDescriptor md = smd.getMethodDescriptor();
                ServerCallHandler handler = smd.getServerCallHandler();
                String methodName = GrpcHelper.extractMethodName((String)md.getFullMethodName());
                MethodDescriptor.Rules descriptor = MethodDescriptor.builder(this.name, methodName, md.toBuilder(), handler).marshallerSupplier(this.marshallerSupplier);
                this.methodBuilders.put(methodName, (MethodDescriptor.Builder)descriptor);
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("name cannot be null");
            }
            if (name.trim().isEmpty()) {
                throw new IllegalArgumentException("name cannot be blank");
            }
            this.name = name.trim();
            for (Map.Entry<String, MethodDescriptor.Builder> entry : this.methodBuilders.entrySet()) {
                entry.getValue().fullname(name + "/" + entry.getKey());
            }
            return this;
        }

        @Override
        public Builder proto(Descriptors.FileDescriptor proto) {
            this.proto = proto;
            return this;
        }

        @Override
        public Builder marshallerSupplier(MarshallerSupplier marshallerSupplier) {
            this.marshallerSupplier = marshallerSupplier;
            return this;
        }

        @Override
        public <ReqT, ResT> Builder unary(String name, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            return this.unary(name, (ServerCalls.UnaryMethod)method, (MethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder unary(String name, ServerCalls.UnaryMethod<ReqT, ResT> method, MethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.UNARY, ServerCalls.asyncUnaryCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder serverStreaming(String name, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            return this.serverStreaming(name, (ServerCalls.ServerStreamingMethod)method, (MethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder serverStreaming(String name, ServerCalls.ServerStreamingMethod<ReqT, ResT> method, MethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.SERVER_STREAMING, ServerCalls.asyncServerStreamingCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder clientStreaming(String name, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            return this.clientStreaming(name, (ServerCalls.ClientStreamingMethod)method, (MethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder clientStreaming(String name, ServerCalls.ClientStreamingMethod<ReqT, ResT> method, MethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.CLIENT_STREAMING, ServerCalls.asyncClientStreamingCall(method), configurer));
            return this;
        }

        @Override
        public <ReqT, ResT> Builder bidirectional(String name, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            return this.bidirectional(name, (ServerCalls.BidiStreamingMethod)method, (MethodDescriptor.Configurer)null);
        }

        @Override
        public <ReqT, ResT> Builder bidirectional(String name, ServerCalls.BidiStreamingMethod<ReqT, ResT> method, MethodDescriptor.Configurer<ReqT, ResT> configurer) {
            this.methodBuilders.put(name, this.createMethodDescriptor(name, MethodDescriptor.MethodType.BIDI_STREAMING, ServerCalls.asyncBidiStreamingCall(method), configurer));
            return this;
        }

        @Override
        public Builder intercept(ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors));
            return this;
        }

        @Override
        public Builder intercept(int priority, ServerInterceptor ... interceptors) {
            this.interceptors.addAll(Arrays.asList(interceptors), priority);
            return this;
        }

        @Override
        public Builder intercept(String methodName, ServerInterceptor ... interceptors) {
            MethodDescriptor.Builder method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with name '" + methodName + "'");
            }
            method.intercept(interceptors);
            return this;
        }

        @Override
        public Builder intercept(String methodName, int priority, ServerInterceptor ... interceptors) {
            MethodDescriptor.Builder method = this.methodBuilders.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("No method exists with name '" + methodName + "'");
            }
            method.intercept(priority, interceptors);
            return this;
        }

        @Override
        public <V> Builder addContextValue(Context.Key<V> key, V value) {
            this.context.put(key, value);
            return this;
        }

        @Override
        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public ServiceDescriptor build() {
            LinkedHashMap<String, MethodDescriptor> methods = new LinkedHashMap<String, MethodDescriptor>();
            String fullName = this.getFullName();
            for (Map.Entry<String, MethodDescriptor.Builder> entry : this.methodBuilders.entrySet()) {
                String methodName = entry.getKey();
                String fullMethodName = io.grpc.MethodDescriptor.generateFullMethodName((String)fullName, (String)methodName);
                methods.put(methodName, (MethodDescriptor)entry.getValue().fullname(fullMethodName).build());
            }
            return new ServiceDescriptor(this.name, methods, this.interceptors, this.context, this.healthCheck, this.proto);
        }

        public String toString() {
            return "ServiceDescriptor.Builder(name='" + this.name + "')";
        }

        private <ReqT, ResT> MethodDescriptor.Builder<ReqT, ResT> createMethodDescriptor(String methodName, MethodDescriptor.MethodType methodType, ServerCallHandler<ReqT, ResT> callHandler, MethodDescriptor.Configurer<ReqT, ResT> configurer) {
            MethodDescriptor.Builder grpcDesc = io.grpc.MethodDescriptor.newBuilder().setFullMethodName(io.grpc.MethodDescriptor.generateFullMethodName((String)this.getFullName(), (String)methodName)).setType(methodType).setSampledToLocalTracing(true);
            Class requestType = this.getTypeFromMethodDescriptor(methodName, true);
            Class responseType = this.getTypeFromMethodDescriptor(methodName, false);
            MethodDescriptor.Builder builder = ((MethodDescriptor.Builder)((MethodDescriptor.Builder)MethodDescriptor.builder(this.name, methodName, grpcDesc, callHandler).defaultMarshallerSupplier(this.marshallerSupplier).requestType(requestType)).responseType(responseType)).fullname(this.getFullName());
            if (configurer != null) {
                configurer.configure(builder);
            }
            return builder;
        }

        private <T> Class<T> getTypeFromMethodDescriptor(String methodName, boolean fInput) {
            if (this.proto == null) {
                return Object.class;
            }
            Descriptors.ServiceDescriptor svc = this.proto.findServiceByName(this.name);
            Descriptors.MethodDescriptor mtd = svc.findMethodByName(methodName);
            Descriptors.Descriptor type = fInput ? mtd.getInputType() : mtd.getOutputType();
            String pkg = this.getPackageName();
            String outerClass = this.getOuterClassName();
            String className = pkg + "." + outerClass + type.getName();
            try {
                return this.serviceClass.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private String getPackageName() {
            String pkg = this.proto.getOptions().getJavaPackage();
            return "".equals(pkg) ? this.proto.getPackage() : pkg;
        }

        private String getFullName() {
            String pkg = this.proto == null ? "" : this.proto.getPackage();
            Object serviceName = this.name;
            if (!pkg.isEmpty() && !((String)serviceName).startsWith(pkg + ".")) {
                serviceName = pkg + "." + (String)serviceName;
            }
            return serviceName;
        }

        private String getOuterClassName() {
            DescriptorProtos.FileOptions options = this.proto.getOptions();
            if (options.getJavaMultipleFiles()) {
                return "";
            }
            String outerClass = options.getJavaOuterClassname();
            if ("".equals(outerClass)) {
                outerClass = this.getOuterClassFromFileName(this.proto.getName());
            }
            return outerClass + "$";
        }

        private String getOuterClassFromFileName(String name) {
            name = name.substring(0, name.lastIndexOf(".proto"));
            String[] words = name.split("_");
            StringBuilder sb = new StringBuilder(name.length());
            for (String word : words) {
                sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
            }
            return sb.toString();
        }
    }

    public static interface Aware {
        public void setServiceDescriptor(ServiceDescriptor var1);
    }

    @FunctionalInterface
    public static interface Configurer {
        public void configure(Rules var1);
    }

    public static interface Rules {
        public Rules name(String var1);

        public String name();

        public Rules proto(Descriptors.FileDescriptor var1);

        public Rules marshallerSupplier(MarshallerSupplier var1);

        public Rules intercept(ServerInterceptor ... var1);

        public Rules intercept(int var1, ServerInterceptor ... var2);

        public Rules intercept(String var1, ServerInterceptor ... var2);

        public Rules intercept(String var1, int var2, ServerInterceptor ... var3);

        public <V> Rules addContextValue(Context.Key<V> var1, V var2);

        public <ReqT, ResT> Rules unary(String var1, ServerCalls.UnaryMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules unary(String var1, ServerCalls.UnaryMethod<ReqT, ResT> var2, MethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules serverStreaming(String var1, ServerCalls.ServerStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules serverStreaming(String var1, ServerCalls.ServerStreamingMethod<ReqT, ResT> var2, MethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules clientStreaming(String var1, ServerCalls.ClientStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules clientStreaming(String var1, ServerCalls.ClientStreamingMethod<ReqT, ResT> var2, MethodDescriptor.Configurer<ReqT, ResT> var3);

        public <ReqT, ResT> Rules bidirectional(String var1, ServerCalls.BidiStreamingMethod<ReqT, ResT> var2);

        public <ReqT, ResT> Rules bidirectional(String var1, ServerCalls.BidiStreamingMethod<ReqT, ResT> var2, MethodDescriptor.Configurer<ReqT, ResT> var3);

        public Rules healthCheck(HealthCheck var1);
    }
}

