/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.health.checks.DiskSpaceHealthCheck;
import io.helidon.health.common.BuiltInHealthCheck;
import java.util.Formatter;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
@BuiltInHealthCheck
public final class HeapMemoryHealthCheck
implements HealthCheck {
    public static final double DEFAULT_THRESHOLD = 98.0;
    private final Runtime rt;
    private final double thresholdPercent;

    @Inject
    HeapMemoryHealthCheck(Runtime runtime, @ConfigProperty(name="helidon.health.heapMemory.thresholdPercent", defaultValue="98") double threshold) {
        this.thresholdPercent = threshold;
        this.rt = runtime;
    }

    private HeapMemoryHealthCheck(Builder builder) {
        this.thresholdPercent = builder.threshold;
        this.rt = Runtime.getRuntime();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HeapMemoryHealthCheck create() {
        return HeapMemoryHealthCheck.builder().build();
    }

    public HealthCheckResponse call() {
        Formatter formatter = new Formatter(Locale.US);
        long freeMemory = this.rt.freeMemory();
        long totalMemory = this.rt.totalMemory();
        long maxMemory = this.rt.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long threshold = (long)(this.thresholdPercent / 100.0 * (double)maxMemory);
        return HealthCheckResponse.named((String)"heapMemory").state(threshold >= usedMemory).withData("percentFree", formatter.format("%.2f%%", 100.0 * ((double)(maxMemory - usedMemory) / (double)maxMemory)).toString()).withData("free", DiskSpaceHealthCheck.format(freeMemory)).withData("freeBytes", freeMemory).withData("max", DiskSpaceHealthCheck.format(maxMemory)).withData("maxBytes", maxMemory).withData("total", DiskSpaceHealthCheck.format(totalMemory)).withData("totalBytes", totalMemory).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<HeapMemoryHealthCheck> {
        private double threshold = 98.0;

        private Builder() {
        }

        public HeapMemoryHealthCheck build() {
            return new HeapMemoryHealthCheck(this);
        }

        public Builder thresholdPercent(double threshold) {
            this.threshold = threshold;
            return this;
        }
    }
}

