/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.health.common.BuiltInHealthCheck;
import java.lang.management.ThreadMXBean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
@BuiltInHealthCheck
public final class DeadlockHealthCheck
implements HealthCheck {
    private final ThreadMXBean threadBean;

    @Inject
    DeadlockHealthCheck(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
    }

    public static DeadlockHealthCheck create(ThreadMXBean threadBean) {
        return new DeadlockHealthCheck(threadBean);
    }

    public HealthCheckResponse call() {
        boolean noDeadLock = this.threadBean.findDeadlockedThreads() == null;
        return HealthCheckResponse.named((String)"deadlock").state(noDeadLock).build();
    }
}

