/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.health.checks.DeadlockHealthCheck;
import io.helidon.health.checks.DiskSpaceHealthCheck;
import io.helidon.health.checks.HeapMemoryHealthCheck;
import java.lang.management.ManagementFactory;
import org.eclipse.microprofile.health.HealthCheck;

public final class HealthChecks {
    private static final boolean IS_GRAAL_VM = Boolean.getBoolean("com.oracle.graalvm.isaot");

    private HealthChecks() {
    }

    public static HealthCheck deadlockCheck() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    public static HealthCheck diskSpaceCheck() {
        return DiskSpaceHealthCheck.create();
    }

    public static HeapMemoryHealthCheck heapMemoryCheck() {
        return HeapMemoryHealthCheck.create();
    }

    public static HealthCheck[] healthChecks() {
        if (IS_GRAAL_VM) {
            return new HealthCheck[]{HealthChecks.heapMemoryCheck()};
        }
        return new HealthCheck[]{HealthChecks.deadlockCheck(), HealthChecks.diskSpaceCheck(), HealthChecks.heapMemoryCheck()};
    }
}

