/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.health.checks.DeadlockHealthCheck;
import io.helidon.health.checks.DiskSpaceHealthCheck;
import io.helidon.health.checks.HeapMemoryHealthCheck;
import java.lang.management.ManagementFactory;
import org.eclipse.microprofile.health.HealthCheck;

public final class HealthChecks {
    private HealthChecks() {
    }

    public static HealthCheck deadlockCheck() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    public static HealthCheck diskSpaceCheck() {
        return DiskSpaceHealthCheck.create();
    }

    public static HeapMemoryHealthCheck heapMemoryCheck() {
        return HeapMemoryHealthCheck.create();
    }

    public static HealthCheck[] healthChecks() {
        if (NativeImageHelper.isNativeImage()) {
            return new HealthCheck[]{HealthChecks.heapMemoryCheck()};
        }
        return new HealthCheck[]{HealthChecks.deadlockCheck(), HealthChecks.diskSpaceCheck(), HealthChecks.heapMemoryCheck()};
    }
}

