/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.health.common.BuiltInHealthCheck;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;

@Liveness
@ApplicationScoped
@BuiltInHealthCheck
public final class DeadlockHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = Logger.getLogger(DeadlockHealthCheck.class.getName());
    private static final String NAME = "deadlock";
    private final ThreadMXBean threadBean;
    private final boolean disabled;

    @Inject
    DeadlockHealthCheck(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
        this.disabled = NativeImageHelper.isNativeImage();
    }

    public static DeadlockHealthCheck create(ThreadMXBean threadBean) {
        return new DeadlockHealthCheck(threadBean);
    }

    public HealthCheckResponse call() {
        if (this.disabled) {
            LOGGER.log(Level.FINEST, "Running in graal native image, this health-check always returns up.");
            return HealthCheckResponse.builder().name(NAME).withData("enabled", "false").withData("description", "in native image").up().build();
        }
        boolean noDeadLock = false;
        try {
            noDeadLock = this.threadBean.findDeadlockedThreads() == null;
        }
        catch (Throwable e) {
            LOGGER.log(Level.FINEST, "Failed to find deadlocks in ThreadMXBean, ignoring this healthcheck", e);
        }
        return HealthCheckResponse.named((String)NAME).state(noDeadLock).build();
    }
}

