/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health.checks;

import io.helidon.common.NativeImageHelper;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class DeadlockHealthCheck
implements HealthCheck {
    private static final System.Logger LOGGER = System.getLogger(DeadlockHealthCheck.class.getName());
    private static final String NAME = "deadlock";
    private static final String PATH = "deadlock";
    private final ThreadMXBean threadBean;
    private final boolean disabled;

    DeadlockHealthCheck(ThreadMXBean threadBean) {
        this.threadBean = threadBean;
        this.disabled = NativeImageHelper.isNativeImage();
    }

    public static DeadlockHealthCheck create(ThreadMXBean threadBean) {
        return new DeadlockHealthCheck(threadBean);
    }

    public static DeadlockHealthCheck create() {
        return DeadlockHealthCheck.create(ManagementFactory.getThreadMXBean());
    }

    public HealthCheckType type() {
        return HealthCheckType.LIVENESS;
    }

    public String name() {
        return "deadlock";
    }

    public String path() {
        return "deadlock";
    }

    public HealthCheckResponse call() {
        if (this.disabled) {
            LOGGER.log(System.Logger.Level.TRACE, "Running in graal native image, this health-check always returns up.");
            return HealthCheckResponse.builder().detail("enabled", (Object)"false").detail("description", (Object)"in native image").status(HealthCheckResponse.Status.UP).build();
        }
        boolean noDeadLock = false;
        try {
            noDeadLock = this.threadBean.findDeadlockedThreads() == null;
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to find deadlocks in ThreadMXBean, ignoring this healthcheck", e);
        }
        return HealthCheckResponse.builder().status(noDeadLock ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN).build();
    }
}

