/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health;

import io.helidon.common.LazyValue;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.Timeout;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public final class HealthSupport
implements Service {
    public static final String DEFAULT_WEB_CONTEXT = "/health";
    private static final String SERVICE_NAME = "Health";
    private static final Logger LOGGER = Logger.getLogger(HealthSupport.class.getName());
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final boolean enabled;
    private final String webContext;
    private final List<HealthCheck> allChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> livenessChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new LinkedList<HealthCheck>();
    private final boolean includeAll;
    private final Set<String> includedHealthChecks;
    private final Set<String> excludedHealthChecks;
    private final boolean backwardCompatible;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private final MessageBodyWriter<JsonStructure> jsonpWriter = JsonpSupport.writer();
    private final LazyValue<? extends Timeout> timeout;
    private final LazyValue<? extends Async> async;

    private HealthSupport(Builder builder) {
        this.enabled = builder.enabled;
        this.webContext = builder.webContext;
        this.backwardCompatible = builder.backwardCompatible;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)SERVICE_NAME, (CrossOriginConfig)builder.crossOriginConfig);
        if (this.enabled) {
            builder.allChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.allChecks::add);
            builder.readinessChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.readinessChecks::add);
            builder.livenessChecks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(this.livenessChecks::add);
            this.includedHealthChecks = new HashSet<String>(builder.includedHealthChecks);
            this.excludedHealthChecks = new HashSet<String>(builder.excludedHealthChecks);
            this.includeAll = this.includedHealthChecks.isEmpty();
        } else {
            this.includeAll = true;
            this.includedHealthChecks = Collections.emptySet();
            this.excludedHealthChecks = Collections.emptySet();
        }
        this.timeout = LazyValue.create(() -> Timeout.create((Duration)Duration.ofMillis(builder.timeoutMillis)));
        this.async = LazyValue.create(Async::create);
    }

    public void update(Routing.Rules rules) {
        if (!this.enabled) {
            return;
        }
        rules.any(this.webContext, new Handler[]{this.corsEnabledServiceHelper.processor()}).get(this.webContext, new Handler[]{this::getAll}).get(this.webContext + "/live", new Handler[]{this::getLiveness}).get(this.webContext + "/ready", new Handler[]{this::getReadiness}).head(this.webContext, new Handler[]{this::headAll}).head(this.webContext + "/live", new Handler[]{this::headLiveness}).head(this.webContext + "/ready", new Handler[]{this::headReadiness});
    }

    private void getAll(ServerRequest req, ServerResponse res) {
        this.get(res, this.allChecks);
    }

    private void getLiveness(ServerRequest req, ServerResponse res) {
        this.get(res, this.livenessChecks);
    }

    private void getReadiness(ServerRequest req, ServerResponse res) {
        this.get(res, this.readinessChecks);
    }

    private void headAll(ServerRequest req, ServerResponse res) {
        this.head(res, this.allChecks);
    }

    private void headLiveness(ServerRequest req, ServerResponse res) {
        this.head(res, this.livenessChecks);
    }

    private void headReadiness(ServerRequest req, ServerResponse res) {
        this.head(res, this.readinessChecks);
    }

    private void get(ServerResponse res, List<HealthCheck> healthChecks) {
        this.invoke(res, healthChecks, true);
    }

    private void head(ServerResponse res, List<HealthCheck> healthChecks) {
        this.invoke(res, healthChecks, false);
    }

    void invoke(ServerResponse res, List<HealthCheck> healthChecks, boolean sendDetails) {
        Single result = ((Timeout)this.timeout.get()).invoke(() -> ((Async)this.async.get()).invoke(() -> this.callHealthChecks(healthChecks)));
        result = result.onErrorResume(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to call health checks", (Throwable)throwable);
            HcResponse response = new HcResponse(HealthCheckResponse.down((String)"InternalError"), true);
            return new HealthResponse((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, this.toJson(HealthCheckResponse.State.DOWN, List.of(response)));
        });
        result.thenAccept(hres -> {
            int status = hres.status().code();
            if (status == Http.Status.OK_200.code() && !sendDetails) {
                status = Http.Status.NO_CONTENT_204.code();
            }
            res.cachingStrategy(ServerResponse.CachingStrategy.NO_CACHING).status(status);
            if (sendDetails) {
                res.send(this.jsonpWriter.marshall((Object)hres.json));
            } else {
                res.send();
            }
        });
    }

    HealthResponse callHealthChecks(List<HealthCheck> healthChecks) {
        List<HcResponse> responses = healthChecks.stream().map(this::callHealthChecks).filter(this::notExcluded).filter(this::allOrIncluded).sorted(Comparator.comparing(HcResponse::name)).collect(Collectors.toList());
        HealthCheckResponse.State state = responses.stream().map(HcResponse::state).filter(arg_0 -> HealthCheckResponse.State.DOWN.equals(arg_0)).findFirst().orElse(HealthCheckResponse.State.UP);
        Http.ResponseStatus status = (Http.ResponseStatus)responses.stream().filter(HcResponse::internalError).findFirst().map(it -> Http.Status.INTERNAL_SERVER_ERROR_500).orElse(state == HealthCheckResponse.State.UP ? Http.Status.OK_200 : Http.Status.SERVICE_UNAVAILABLE_503);
        JsonObject json = this.toJson(state, responses);
        return new HealthResponse(status, json);
    }

    private JsonObject toJson(HealthCheckResponse.State state, List<HcResponse> responses) {
        JsonObjectBuilder jsonBuilder = JSON.createObjectBuilder();
        if (this.backwardCompatible) {
            jsonBuilder.add("outcome", state.toString());
        }
        jsonBuilder.add("status", state.toString());
        JsonArrayBuilder checkArrayBuilder = JSON.createArrayBuilder();
        for (HcResponse r : responses) {
            JsonObjectBuilder checkBuilder = JSON.createObjectBuilder();
            checkBuilder.add("name", r.name());
            checkBuilder.add("state", r.state().toString());
            checkBuilder.add("status", r.state().toString());
            Optional<Map<String, Object>> data = r.data();
            data.ifPresent(m -> checkBuilder.add("data", JSON.createObjectBuilder(m)));
            checkArrayBuilder.add(checkBuilder);
        }
        jsonBuilder.add("checks", checkArrayBuilder);
        return jsonBuilder.build();
    }

    private boolean allOrIncluded(HcResponse response) {
        return this.includeAll || this.includedHealthChecks.contains(response.hcr.getName());
    }

    private boolean notExcluded(HcResponse response) {
        return !this.excludedHealthChecks.contains(response.hcr.getName());
    }

    private HcResponse callHealthChecks(HealthCheck hc) {
        try {
            return new HcResponse(hc.call());
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to compute health check for " + hc.getClass().getName(), e);
            return new HcResponse(HealthCheckResponse.named((String)hc.getClass().getName()).withData("message", "Failed to compute health. Error logged").down().build(), true);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HealthSupport create() {
        return HealthSupport.builder().build();
    }

    public static HealthSupport create(Config config) {
        return HealthSupport.builder().config(config).build();
    }

    static final class HealthResponse {
        private final Http.ResponseStatus status;
        private final JsonObject json;

        private HealthResponse(Http.ResponseStatus status, JsonObject json) {
            this.status = status;
            this.json = json;
        }

        Http.ResponseStatus status() {
            return this.status;
        }

        JsonObject json() {
            return this.json;
        }
    }

    private static final class HcResponse {
        private final HealthCheckResponse hcr;
        private final boolean internalServerError;

        private HcResponse(HealthCheckResponse response, boolean internalServerError) {
            this.hcr = response;
            this.internalServerError = internalServerError;
        }

        private HcResponse(HealthCheckResponse response) {
            this(response, false);
        }

        String name() {
            return this.hcr.getName();
        }

        HealthCheckResponse.State state() {
            return this.hcr.getState();
        }

        boolean internalError() {
            return this.internalServerError;
        }

        public Optional<Map<String, Object>> data() {
            return this.hcr.getData();
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<HealthSupport> {
        private static final long DEFAULT_TIMEOUT_MILLIS = 10000L;
        private final List<HealthCheck> allChecks = new LinkedList<HealthCheck>();
        private final List<HealthCheck> livenessChecks = new LinkedList<HealthCheck>();
        private final List<HealthCheck> readinessChecks = new LinkedList<HealthCheck>();
        private final Set<Class<?>> excludedClasses = new HashSet();
        private final Set<String> includedHealthChecks = new HashSet<String>();
        private final Set<String> excludedHealthChecks = new HashSet<String>();
        private String webContext = "/health";
        private boolean enabled = true;
        private boolean backwardCompatible = true;
        private CrossOriginConfig crossOriginConfig;
        private long timeoutMillis = 10000L;

        private Builder() {
        }

        public HealthSupport build() {
            return new HealthSupport(this);
        }

        public Builder webContext(String path) {
            this.webContext = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        @Deprecated
        public Builder add(HealthCheck ... healthChecks) {
            this.allChecks.addAll(Arrays.asList(healthChecks));
            return this;
        }

        public Builder addIncluded(String healthCheckName) {
            this.includedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addIncluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.includedHealthChecks.addAll(names);
            return this;
        }

        public Builder addExcluded(String healthCheckName) {
            this.excludedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addExcluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.excludedHealthChecks.addAll(names);
            return this;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("web-context").asString().ifPresent(this::webContext);
            config.get("include").asList(String.class).ifPresent(list -> list.forEach(this::addIncluded));
            config.get("exclude").asList(String.class).ifPresent(list -> list.forEach(this::addExcluded));
            config.get("exclude-classes").asList(Class.class).ifPresent(list -> list.forEach(this::addExcludedClass));
            config.get("backward-compatible").asBoolean().ifPresent(this::backwardCompatible);
            config.get("timeout-millis").asLong().ifPresent(this::timeoutMillis);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return this;
        }

        private void timeoutMillis(long aLong) {
            this.timeoutMillis = aLong;
        }

        public Builder timeout(long timeout, TimeUnit unit) {
            this.timeoutMillis(unit.toMillis(timeout));
            return this;
        }

        public Builder addExcludedClass(Class<?> aClass) {
            this.excludedClasses.add(aClass);
            return this;
        }

        public Builder addLiveness(HealthCheck ... healthChecks) {
            return this.addLiveness(List.of(healthChecks));
        }

        public Builder addLiveness(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            this.livenessChecks.addAll(healthChecks);
            return this;
        }

        public Builder addReadiness(HealthCheck ... healthChecks) {
            return this.addReadiness(List.of(healthChecks));
        }

        public Builder addReadiness(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            this.readinessChecks.addAll(healthChecks);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Deprecated
        public Builder backwardCompatible(boolean enabled) {
            this.backwardCompatible = enabled;
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }
    }
}

