/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health;

import io.helidon.common.http.Http;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.Timeout;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.servicecommon.rest.HelidonRestServiceSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

public final class HealthSupport
extends HelidonRestServiceSupport {
    public static final String DEFAULT_WEB_CONTEXT = "/health";
    private static final String SERVICE_NAME = "Health";
    private static final Logger LOGGER = Logger.getLogger(HealthSupport.class.getName());
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private final boolean enabled;
    private final List<HealthCheck> allChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> livenessChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new LinkedList<HealthCheck>();
    private final List<HealthCheck> startupChecks = new LinkedList<HealthCheck>();
    private final boolean includeAll;
    private final Set<String> includedHealthChecks;
    private final Set<String> excludedHealthChecks;
    private final MessageBodyWriter<JsonStructure> jsonpWriter = JsonpSupport.writer();
    private final Timeout timeout;
    private final Async async;

    private HealthSupport(Builder builder) {
        super(LOGGER, (HelidonRestServiceSupport.Builder)builder, SERVICE_NAME);
        this.enabled = builder.enabled;
        if (this.enabled) {
            HealthSupport.collectNonexcludedChecks(builder, builder.allChecks, this.allChecks::add);
            HealthSupport.collectNonexcludedChecks(builder, builder.readinessChecks, this.readinessChecks::add);
            HealthSupport.collectNonexcludedChecks(builder, builder.livenessChecks, this.livenessChecks::add);
            HealthSupport.collectNonexcludedChecks(builder, builder.startupChecks, this.startupChecks::add);
            this.includedHealthChecks = new HashSet<String>(builder.includedHealthChecks);
            this.excludedHealthChecks = new HashSet<String>(builder.excludedHealthChecks);
            this.includeAll = this.includedHealthChecks.isEmpty();
        } else {
            this.includeAll = true;
            this.includedHealthChecks = Collections.emptySet();
            this.excludedHealthChecks = Collections.emptySet();
        }
        this.timeout = Timeout.create((Duration)Duration.ofMillis(builder.timeoutMillis));
        this.async = Async.create();
    }

    public void update(Routing.Rules rules) {
        this.configureEndpoint(rules, rules);
    }

    protected void postConfigureEndpoint(Routing.Rules defaultRules, Routing.Rules serviceEndpointRoutingRules) {
        if (this.enabled) {
            serviceEndpointRoutingRules.get(this.context(), new Handler[]{this::getAll}).get(this.context() + "/live", new Handler[]{this::getLiveness}).get(this.context() + "/ready", new Handler[]{this::getReadiness}).get(this.context() + "/started", new Handler[]{this::getStartup}).head(this.context(), new Handler[]{this::headAll}).head(this.context() + "/live", new Handler[]{this::headLiveness}).head(this.context() + "/ready", new Handler[]{this::headReadiness}).head(this.context() + "/started", new Handler[]{this::headStartup});
        }
    }

    private static void collectNonexcludedChecks(Builder builder, List<HealthCheck> checks, Consumer<HealthCheck> adder) {
        checks.stream().filter(health -> !builder.excludedClasses.contains(health.getClass())).forEach(adder);
    }

    private void getAll(ServerRequest req, ServerResponse res) {
        this.get(res, this.allChecks);
    }

    private void getLiveness(ServerRequest req, ServerResponse res) {
        this.get(res, this.livenessChecks);
    }

    private void getReadiness(ServerRequest req, ServerResponse res) {
        this.get(res, this.readinessChecks);
    }

    private void getStartup(ServerRequest req, ServerResponse res) {
        this.get(res, this.startupChecks);
    }

    private void headAll(ServerRequest req, ServerResponse res) {
        this.head(res, this.allChecks);
    }

    private void headLiveness(ServerRequest req, ServerResponse res) {
        this.head(res, this.livenessChecks);
    }

    private void headReadiness(ServerRequest req, ServerResponse res) {
        this.head(res, this.readinessChecks);
    }

    private void headStartup(ServerRequest req, ServerResponse res) {
        this.head(res, this.startupChecks);
    }

    private void get(ServerResponse res, List<HealthCheck> healthChecks) {
        this.invoke(res, healthChecks, true);
    }

    private void head(ServerResponse res, List<HealthCheck> healthChecks) {
        this.invoke(res, healthChecks, false);
    }

    void invoke(ServerResponse res, List<HealthCheck> healthChecks, boolean sendDetails) {
        Single result = this.timeout.invoke(() -> this.async.invoke(() -> this.callHealthChecks(healthChecks)));
        result = result.onErrorResume(throwable -> {
            LOGGER.log(Level.SEVERE, "Failed to call health checks", (Throwable)throwable);
            HcResponse response = new HcResponse(HealthCheckResponse.down((String)"InternalError"), true);
            return new HealthResponse((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, this.toJson(HealthCheckResponse.Status.DOWN, List.of(response)));
        });
        result.thenAccept(hres -> {
            int status = hres.status().code();
            if (status == Http.Status.OK_200.code() && !sendDetails) {
                status = Http.Status.NO_CONTENT_204.code();
            }
            res.cachingStrategy(ServerResponse.CachingStrategy.NO_CACHING).status(status);
            if (sendDetails) {
                res.send(this.jsonpWriter.marshall((Object)hres.json));
            } else {
                res.send();
            }
        });
    }

    HealthResponse callHealthChecks(List<HealthCheck> healthChecks) {
        List<HcResponse> responses = healthChecks.stream().map(this::callHealthChecks).filter(this::notExcluded).filter(this::allOrIncluded).sorted(Comparator.comparing(HcResponse::name)).collect(Collectors.toList());
        HealthCheckResponse.Status status = responses.stream().map(HcResponse::status).filter(arg_0 -> HealthCheckResponse.Status.DOWN.equals(arg_0)).findFirst().orElse(HealthCheckResponse.Status.UP);
        Http.ResponseStatus httpStatus = (Http.ResponseStatus)responses.stream().filter(HcResponse::internalError).findFirst().map(it -> Http.Status.INTERNAL_SERVER_ERROR_500).orElse(status == HealthCheckResponse.Status.UP ? Http.Status.OK_200 : Http.Status.SERVICE_UNAVAILABLE_503);
        JsonObject json = this.toJson(status, responses);
        return new HealthResponse(httpStatus, json);
    }

    private JsonObject toJson(HealthCheckResponse.Status status, List<HcResponse> responses) {
        JsonObjectBuilder jsonBuilder = JSON.createObjectBuilder();
        jsonBuilder.add("status", status.toString());
        JsonArrayBuilder checkArrayBuilder = JSON.createArrayBuilder();
        for (HcResponse r : responses) {
            JsonObjectBuilder checkBuilder = JSON.createObjectBuilder();
            checkBuilder.add("name", r.name());
            checkBuilder.add("status", r.status().toString());
            Optional<Map<String, Object>> data = r.data();
            data.ifPresent(m -> checkBuilder.add("data", JSON.createObjectBuilder(m)));
            checkArrayBuilder.add(checkBuilder);
        }
        jsonBuilder.add("checks", checkArrayBuilder);
        return jsonBuilder.build();
    }

    private boolean allOrIncluded(HcResponse response) {
        return this.includeAll || this.includedHealthChecks.contains(response.hcr.getName());
    }

    private boolean notExcluded(HcResponse response) {
        return !this.excludedHealthChecks.contains(response.hcr.getName());
    }

    private HcResponse callHealthChecks(HealthCheck hc) {
        try {
            return new HcResponse(hc.call());
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Failed to compute health check for " + hc.getClass().getName(), e);
            return new HcResponse(HealthCheckResponse.named((String)hc.getClass().getName()).withData("message", "Failed to compute health. Error logged").down().build(), true);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HealthSupport create() {
        return HealthSupport.builder().build();
    }

    public static HealthSupport create(Config config) {
        return HealthSupport.builder().config(config).build();
    }

    @Configured(prefix="health", root=true)
    public static final class Builder
    extends HelidonRestServiceSupport.Builder<Builder, HealthSupport> {
        public static final String HEALTH_CONFIG_KEY = "health";
        public static final String ENABLED_CONFIG_KEY = "enabled";
        public static final String INCLUDE_CONFIG_KEY = "include";
        public static final String EXCLUDE_CONFIG_KEY = "exclude";
        public static final String EXCLUDE_CLASSES_CONFIG_KEY = "exclude-classes";
        public static final String TIMEOUT_CONFIG_KEY = "timeout-millis";
        private static final long DEFAULT_TIMEOUT_MILLIS = 10000L;
        private static final boolean DEFAULT_ENABLED = true;
        private final List<HealthCheck> allChecks = new LinkedList<HealthCheck>();
        private final List<HealthCheck> livenessChecks = new LinkedList<HealthCheck>();
        private final List<HealthCheck> readinessChecks = new LinkedList<HealthCheck>();
        private final List<HealthCheck> startupChecks = new LinkedList<HealthCheck>();
        private final Set<Class<?>> excludedClasses = new HashSet();
        private final Set<String> includedHealthChecks = new HashSet<String>();
        private final Set<String> excludedHealthChecks = new HashSet<String>();
        private boolean enabled = true;
        private long timeoutMillis = 10000L;

        private Builder() {
            super(HealthSupport.DEFAULT_WEB_CONTEXT);
        }

        public HealthSupport build() {
            return new HealthSupport(this);
        }

        public Builder addIncluded(String healthCheckName) {
            this.includedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addIncluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.includedHealthChecks.addAll(names);
            return this;
        }

        public Builder addExcluded(String healthCheckName) {
            this.excludedHealthChecks.add(healthCheckName);
            return this;
        }

        public Builder addExcluded(Collection<String> names) {
            if (null == names) {
                return this;
            }
            this.excludedHealthChecks.addAll(names);
            return this;
        }

        public Builder config(Config config) {
            super.config(config);
            config.get(ENABLED_CONFIG_KEY).asBoolean().ifPresent(this::enabled);
            config.get(INCLUDE_CONFIG_KEY).asList(String.class).ifPresent(list -> list.forEach(this::addIncluded));
            config.get(EXCLUDE_CONFIG_KEY).asList(String.class).ifPresent(list -> list.forEach(this::addExcluded));
            config.get(EXCLUDE_CLASSES_CONFIG_KEY).asList(Class.class).ifPresent(list -> list.forEach(this::addExcludedClass));
            config.get(TIMEOUT_CONFIG_KEY).asLong().ifPresent(this::timeoutMillis);
            return this;
        }

        private void timeoutMillis(long aLong) {
            this.timeoutMillis = aLong;
        }

        public Builder timeout(long timeout, TimeUnit unit) {
            this.timeoutMillis(unit.toMillis(timeout));
            return this;
        }

        public Builder addExcludedClass(Class<?> aClass) {
            this.excludedClasses.add(aClass);
            return this;
        }

        public Builder addLiveness(HealthCheck ... healthChecks) {
            return this.addLiveness(List.of(healthChecks));
        }

        public Builder addLiveness(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            this.livenessChecks.addAll(healthChecks);
            return this;
        }

        public Builder addReadiness(HealthCheck ... healthChecks) {
            return this.addReadiness(List.of(healthChecks));
        }

        public Builder addReadiness(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            this.readinessChecks.addAll(healthChecks);
            return this;
        }

        public Builder addStartup(HealthCheck ... healthChecks) {
            return this.addStartup(List.of(healthChecks));
        }

        public Builder addStartup(Collection<HealthCheck> healthChecks) {
            this.allChecks.addAll(healthChecks);
            this.startupChecks.addAll(healthChecks);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }
    }

    static final class HealthResponse {
        private final Http.ResponseStatus status;
        private final JsonObject json;

        private HealthResponse(Http.ResponseStatus status, JsonObject json) {
            this.status = status;
            this.json = json;
        }

        Http.ResponseStatus status() {
            return this.status;
        }

        JsonObject json() {
            return this.json;
        }
    }

    private static final class HcResponse {
        private final HealthCheckResponse hcr;
        private final boolean internalServerError;

        private HcResponse(HealthCheckResponse response, boolean internalServerError) {
            this.hcr = response;
            this.internalServerError = internalServerError;
        }

        private HcResponse(HealthCheckResponse response) {
            this(response, false);
        }

        String name() {
            return this.hcr.getName();
        }

        HealthCheckResponse.Status status() {
            return this.hcr.getStatus();
        }

        boolean internalError() {
            return this.internalServerError;
        }

        public Optional<Map<String, Object>> data() {
            return this.hcr.getData();
        }
    }
}

