/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.health;

import io.helidon.health.HealthResponseImpl;
import java.util.HashMap;
import java.util.Map;

public interface HealthCheckResponse {
    public static Builder builder() {
        return new Builder();
    }

    public Status status();

    public Map<String, Object> details();

    public static class Builder
    implements io.helidon.common.Builder<Builder, HealthCheckResponse> {
        private final Map<String, Object> details = new HashMap<String, Object>();
        private Status status = Status.UP;

        public HealthCheckResponse build() {
            return new HealthResponseImpl(this.status, this.details);
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder status(boolean status) {
            this.status = status ? Status.UP : Status.DOWN;
            return this;
        }

        public Builder detail(String name, Object value) {
            this.details.put(name, value);
            return this;
        }

        Map<String, Object> details() {
            return this.details;
        }

        Status status() {
            return this.status;
        }
    }

    public static enum Status {
        UP,
        DOWN,
        ERROR;

    }
}

