/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2HuffmanEncoder;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2StreamWriter;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Http2ConnectionWriter
implements Http2StreamWriter {
    private final DataWriter writer;
    private final Lock streamLock = new ReentrantLock(true);
    private final SocketContext ctx;
    private final Http2FrameListener listener;
    private final Http2Headers.DynamicTable outboundDynamicTable;
    private final Http2HuffmanEncoder responseHuffman;
    private final BufferData headerBuffer = BufferData.growing((int)512);

    public Http2ConnectionWriter(SocketContext ctx, DataWriter writer, List<Http2FrameListener> sendFrameListeners) {
        this.ctx = ctx;
        this.listener = Http2FrameListener.create(sendFrameListeners);
        this.writer = writer;
        this.outboundDynamicTable = Http2Headers.DynamicTable.create(Http2Setting.HEADER_TABLE_SIZE.defaultValue());
        this.responseHuffman = Http2HuffmanEncoder.create();
    }

    @Override
    public void write(Http2FrameData frame) {
        this.lockedWrite(frame);
    }

    @Override
    public void writeData(Http2FrameData frame, FlowControl.Outbound flowControl) {
        for (Http2FrameData f : frame.split(flowControl.maxFrameSize())) {
            this.splitAndWrite(f, flowControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeHeaders(Http2Headers headers, int streamId, Http2Flag.HeaderFlags flags, FlowControl.Outbound flowControl) {
        int maxFrameSize = flowControl.maxFrameSize();
        this.lock();
        try {
            int written = 0;
            this.headerBuffer.clear();
            headers.write(this.outboundDynamicTable, this.responseHuffman, this.headerBuffer);
            if (this.headerBuffer.available() <= maxFrameSize) {
                Http2FrameHeader frameHeader = Http2FrameHeader.create(this.headerBuffer.available(), Http2FrameTypes.HEADERS, flags, streamId);
                written += frameHeader.length();
                this.noLockWrite(new Http2FrameData(frameHeader, this.headerBuffer));
                int n = written += 9;
                return n;
            }
            BufferData[] fragments = Http2Headers.split(this.headerBuffer, maxFrameSize);
            BufferData fragment = fragments[0];
            Http2FrameHeader frameHeader = Http2FrameHeader.create(fragment.available(), Http2FrameTypes.HEADERS, Http2Flag.HeaderFlags.create(0), streamId);
            written += frameHeader.length();
            written += 9;
            this.noLockWrite(new Http2FrameData(frameHeader, fragment));
            for (int i = 1; i < fragments.length; ++i) {
                fragment = fragments[i];
                frameHeader = Http2FrameHeader.create(fragment.available(), Http2FrameTypes.CONTINUATION, Http2Flag.ContinuationFlags.create(0), streamId);
                written += frameHeader.length();
                written += 9;
                this.noLockWrite(new Http2FrameData(frameHeader, fragment));
            }
            fragment = fragments[fragments.length - 1];
            frameHeader = Http2FrameHeader.create(fragment.available(), Http2FrameTypes.CONTINUATION, Http2Flag.ContinuationFlags.create(flags.value() | 4), streamId);
            written += frameHeader.length();
            this.noLockWrite(new Http2FrameData(frameHeader, fragment));
            int n = written += 9;
            return n;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    @Override
    public int writeHeaders(Http2Headers headers, int streamId, Http2Flag.HeaderFlags flags, Http2FrameData dataFrame, FlowControl.Outbound flowControl) {
        int bytesWritten = 0;
        bytesWritten += this.writeHeaders(headers, streamId, flags, flowControl);
        this.writeData(dataFrame, flowControl);
        bytesWritten += 9;
        return bytesWritten += dataFrame.header().length();
    }

    public void updateHeaderTableSize(long newSize) throws InterruptedException {
        this.lock();
        try {
            this.outboundDynamicTable.protocolMaxTableSize(newSize);
        }
        finally {
            this.streamLock.unlock();
        }
    }

    private void lockedWrite(Http2FrameData frame) {
        this.lock();
        try {
            this.noLockWrite(frame);
        }
        finally {
            this.streamLock.unlock();
        }
    }

    private void lock() {
        try {
            this.streamLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted", e);
        }
    }

    private void noLockWrite(Http2FrameData frame) {
        Http2FrameHeader frameHeader = frame.header();
        int streamId = frameHeader.streamId();
        this.listener.frameHeader(this.ctx, streamId, frameHeader);
        BufferData headerData = frameHeader.write();
        this.listener.frameHeader(this.ctx, streamId, headerData);
        if (frameHeader.length() == 0) {
            this.writer.write(headerData);
        } else {
            BufferData data = frame.data().copy();
            this.listener.frame(this.ctx, streamId, data);
            this.writer.write(BufferData.create((BufferData[])new BufferData[]{headerData, data}));
        }
    }

    private void splitAndWrite(Http2FrameData frame, FlowControl.Outbound flowControl) {
        Http2FrameData currFrame = frame;
        while (true) {
            Http2FrameData[] splitFrames;
            if ((splitFrames = flowControl.cut(currFrame)).length == 1) break;
            if (splitFrames.length == 0) {
                flowControl.blockTillUpdate();
                continue;
            }
            if (splitFrames.length != 2) continue;
            this.lockedWrite(splitFrames[0]);
            flowControl.decrementWindowSize(splitFrames[0].header().length());
            flowControl.blockTillUpdate();
            currFrame = splitFrames[1];
        }
        this.lockedWrite(currFrame);
        flowControl.decrementWindowSize(currFrame.header().length());
    }
}

