/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Settings;

public final class Http2Continuation
implements Http2Frame<Http2Flag.ContinuationFlags> {
    private final BufferData data;

    private Http2Continuation(BufferData data) {
        this.data = data;
    }

    public static Http2Continuation create(BufferData data) {
        return new Http2Continuation(data);
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.ContinuationFlags flags) {
        Http2FrameHeader header = Http2FrameHeader.create(this.data.available(), this.frameTypes(), flags, streamId);
        return new Http2FrameData(header, this.data);
    }

    @Override
    public String name() {
        return Http2FrameType.CONTINUATION.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.CONTINUATION;
    }

    @Override
    public Http2FrameTypes<Http2Flag.ContinuationFlags> frameTypes() {
        return Http2FrameTypes.CONTINUATION;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.data.available()];
        this.data.read(result, 0, result.length);
        this.data.rewind();
        return result;
    }
}

